/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.annotations.Facet;
import org.richfaces.cdk.annotations.JsfComponent;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.CdkAnnotationProcessor;
import org.richfaces.cdk.apt.processors.ProcessorBase;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ComponentModel;
import org.richfaces.cdk.model.EventModel;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.FacetModel;

public class ComponentProcessor
extends ProcessorBase
implements CdkAnnotationProcessor {
    public static final String COMPONENT_FAMILY = "COMPONENT_FAMILY";
    public static final String COMPONENT_TYPE = "COMPONENT_TYPE";

    @Override
    public void process(Element componentElement, ComponentLibrary library) {
        SourceUtils sourceUtils = this.getSourceUtils();
        if (sourceUtils.isAnnotationPresent(componentElement, JsfComponent.class)) {
            AnnotationMirror annotation = sourceUtils.getAnnotationMirror(componentElement, JsfComponent.class);
            ComponentModel component = new ComponentModel();
            this.setClassNames((TypeElement)componentElement, component, annotation);
            this.setComponentProperties((TypeElement)componentElement, component, annotation);
            library.getComponents().add(component);
            for (AnnotationMirror subcomponent : sourceUtils.getAnnotationValues(annotation, "components", AnnotationMirror.class)) {
                ComponentModel subcomponentModel = new ComponentModel();
                subcomponentModel.setBaseClass(component.getTargetClass());
                if (!sourceUtils.isDefaultValue(subcomponent, "generate")) {
                    subcomponentModel.setTargetClass(sourceUtils.getAnnotationValue(subcomponent, "generate", ClassName.class));
                    subcomponentModel.setGenerate(true);
                }
                this.setComponentProperties(null, subcomponentModel, subcomponent);
                library.getComponents().add(subcomponentModel);
            }
        }
    }

    void setComponentProperties(TypeElement componentElement, ComponentModel component, AnnotationMirror annotation) throws CdkException {
        SourceUtils sourceUtils = this.getSourceUtils();
        this.setComponentType(componentElement, component, annotation);
        this.setComponeneFamily(componentElement, component, annotation);
        this.setDescription(component, annotation, this.getDocComment(componentElement));
        if (!sourceUtils.isDefaultValue(annotation, "renderer")) {
            this.setRendererType(component, sourceUtils.getAnnotationValue(annotation, "renderer", AnnotationMirror.class));
        }
        this.processFacets(componentElement, component, annotation);
        this.processAttributes(componentElement, component, annotation);
        this.processEvents(componentElement, component, annotation);
        for (TypeMirror atributesInterface : sourceUtils.getAnnotationValues(annotation, "interfaces", TypeMirror.class)) {
            if (!TypeKind.DECLARED.equals((Object)atributesInterface.getKind())) continue;
            this.processFacetsFromType(sourceUtils.asTypeElement(atributesInterface), component, sourceUtils);
        }
        this.setTagInfo(annotation, component);
    }

    private void setRendererType(ComponentModel component, AnnotationMirror annotation) {
        SourceUtils sourceUtils = this.getSourceUtils();
        if (!sourceUtils.isDefaultValue(annotation, "type")) {
            component.setRendererType(sourceUtils.getAnnotationValue(annotation, "type", FacesId.class));
        }
        if (!sourceUtils.isDefaultValue(annotation, "template")) {
            component.setRendererTemplate(sourceUtils.getAnnotationValue(annotation, "template", String.class));
        }
    }

    void setComponentType(TypeElement componentElement, ComponentModel component, AnnotationMirror annotation) {
        component.setId(FacesId.parseId(this.getAnnotationPropertyOrConstant(componentElement, annotation, "type", COMPONENT_TYPE)));
    }

    final void processFacets(TypeElement componentElement, ComponentModel component, AnnotationMirror annotation) {
        SourceUtils sourceUtils = this.getSourceUtils();
        this.processFacetsFromType(componentElement, component, sourceUtils);
        for (AnnotationMirror facet : sourceUtils.getAnnotationValues(annotation, "facets", AnnotationMirror.class)) {
            if (!sourceUtils.isDefaultValue(facet, "name")) {
                String name = sourceUtils.getAnnotationValue(facet, "name", String.class);
                FacetModel facetModel = component.getOrCreateFacet(name);
                this.processFacet(facet, facetModel, null);
                continue;
            }
            throw new CdkException("Facet name should be set");
        }
    }

    private void processFacetsFromType(TypeElement componentElement, ComponentModel component, SourceUtils sourceUtils) {
        if (null != componentElement) {
            Set<SourceUtils.BeanProperty> properties = sourceUtils.getBeanPropertiesAnnotatedWith(Facet.class, componentElement);
            for (SourceUtils.BeanProperty beanProperty : properties) {
                AnnotationMirror facet = beanProperty.getAnnotationMirror(Facet.class);
                FacetModel facetModel = component.getOrCreateFacet(beanProperty.getName());
                facetModel.setDescription(beanProperty.getDocComment());
                this.processFacet(facet, facetModel, beanProperty.getDocComment());
                if (beanProperty.isExists()) continue;
                facetModel.setGenerate(true);
            }
        }
    }

    final void processFacet(AnnotationMirror facet, FacetModel facetModel, String docComment) {
        SourceUtils sourceUtils = this.getSourceUtils();
        if (!sourceUtils.isDefaultValue(facet, "description")) {
            this.setDescription(facetModel, facet, docComment);
        }
        if (!sourceUtils.isDefaultValue(facet, "generate")) {
            facetModel.setGenerate(sourceUtils.getAnnotationValue(facet, "generate", Boolean.class));
        }
    }

    final void setComponeneFamily(TypeElement componentElement, ComponentModel component, AnnotationMirror annotation) {
        if (null != componentElement) {
            component.setFamily(FacesId.parseId(this.getAnnotationPropertyOrConstant(componentElement, annotation, "family", COMPONENT_FAMILY)));
        }
    }

    final void processEvents(TypeElement componentElement, ComponentModel component, AnnotationMirror annotation) {
        SourceUtils sourceUtils = this.getSourceUtils();
        for (AnnotationMirror event : sourceUtils.getAnnotationValues(annotation, "fires", AnnotationMirror.class)) {
            EventModel model = new EventModel();
            sourceUtils.setModelProperty(model, event, "type", "value");
            sourceUtils.setModelProperty(model, event, "listenerInterface", "listener");
            sourceUtils.setModelProperty(model, event, "listenerMethod");
            sourceUtils.setModelProperty(model, event, "sourceInterface", "source");
            component.getEvents().add(model);
        }
    }

    @Override
    public final Class<? extends Annotation> getProcessedAnnotation() {
        return JsfComponent.class;
    }
}

