/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.apt.processors;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.NamingConventions;
import org.richfaces.cdk.annotations.TagType;
import org.richfaces.cdk.apt.SourceUtils;
import org.richfaces.cdk.apt.processors.AttributesProcessor;
import org.richfaces.cdk.apt.processors.DescriptionProcessor;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.DescriptionGroup;
import org.richfaces.cdk.model.GeneratedFacesComponent;
import org.richfaces.cdk.model.ModelCollection;
import org.richfaces.cdk.model.ModelElementBase;
import org.richfaces.cdk.model.TagModel;
import org.richfaces.cdk.model.ViewElement;

public abstract class ProcessorBase {
    @Inject
    protected Logger log;
    @Inject
    private Provider<SourceUtils> sourceUtils;
    @Inject
    private AttributesProcessor attributeProcessor;
    @Inject
    private NamingConventions namingConventions;
    @Inject
    private DescriptionProcessor descriptionProcessor;

    public SourceUtils getSourceUtils() {
        return (SourceUtils)this.sourceUtils.get();
    }

    protected void setTagInfo(AnnotationMirror annotation, ViewElement model) {
        SourceUtils sourceUtils = this.getSourceUtils();
        ModelCollection<TagModel> tags = model.getTags();
        for (AnnotationMirror tag : sourceUtils.getAnnotationValues(annotation, "tag", AnnotationMirror.class)) {
            TagModel tagModel = this.processTag(tag);
            tags.add(tagModel);
        }
    }

    protected TagModel processTag(AnnotationMirror tag) {
        TagModel tagModel = new TagModel();
        SourceUtils sourceUtils = this.getSourceUtils();
        sourceUtils.setModelProperty(tagModel, tag, "name");
        tagModel.setType(sourceUtils.getAnnotationValue(tag, "type", TagType.class));
        sourceUtils.setModelProperty(tagModel, tag, "targetClass", "handler");
        sourceUtils.setModelProperty(tagModel, tag, "baseClass");
        sourceUtils.setModelProperty(tagModel, tag, "generate");
        return tagModel;
    }

    protected void setClassNames(TypeElement componentElement, GeneratedFacesComponent modelElement, AnnotationMirror behavior) {
        SourceUtils sourceUtils = this.getSourceUtils();
        if (componentElement.getModifiers().contains((Object)Modifier.ABSTRACT) || !sourceUtils.isDefaultValue(behavior, "generate")) {
            modelElement.setGenerate(true);
            sourceUtils.setModelProperty(modelElement, behavior, "targetClass", "generate");
        } else {
            modelElement.setGenerate(false);
            modelElement.setTargetClass(ClassName.parseName(componentElement.getQualifiedName().toString()));
        }
        modelElement.setBaseClass(ClassName.parseName(componentElement.getQualifiedName().toString()));
    }

    protected String getDocComment(Element element) {
        return null != element ? this.getSourceUtils().getDocComment(element) : null;
    }

    protected AttributesProcessor getAttributeProcessor() {
        return this.attributeProcessor;
    }

    public NamingConventions getNamingConventions() {
        return this.namingConventions;
    }

    public void setNamingConventions(NamingConventions namingConventions) {
        this.namingConventions = namingConventions;
    }

    protected void setDescription(DescriptionGroup model, AnnotationMirror annotation, String docComment) {
        this.descriptionProcessor.processDescription(model, this.getSourceUtils().getAnnotationValue(annotation, "description", AnnotationMirror.class), docComment);
    }

    protected void processAttributes(Element element, ModelElementBase component, AnnotationMirror annotation) {
        AttributesProcessor attributesProcessor = this.getAttributeProcessor();
        SourceUtils sourceUtils = this.getSourceUtils();
        for (String atributesFragment : sourceUtils.getAnnotationValues(annotation, "attributes", String.class)) {
            attributesProcessor.processXmlFragment(component, atributesFragment);
        }
        if (element != null && ElementKind.CLASS.equals((Object)element.getKind())) {
            attributesProcessor.processType(component, (TypeElement)element);
        }
        for (TypeMirror atributesInterface : sourceUtils.getAnnotationValues(annotation, "interfaces", TypeMirror.class)) {
            this.processInterface(component, attributesProcessor, atributesInterface);
        }
    }

    private void processInterface(ModelElementBase component, AttributesProcessor attributesProcessor, TypeMirror mirror) {
        component.getInterfaces().add(ClassName.parseName(((Object)mirror).toString()));
        if (TypeKind.DECLARED.equals((Object)mirror.getKind())) {
            attributesProcessor.processType(component, this.getSourceUtils().asTypeElement(mirror));
        }
    }

    protected String getAnnotationPropertyOrConstant(TypeElement element, AnnotationMirror annotation, String annotationAttribute, String fieldName) {
        Object value;
        SourceUtils utils = this.getSourceUtils();
        if (!utils.isDefaultValue(annotation, annotationAttribute)) {
            return utils.getAnnotationValue(annotation, annotationAttribute, String.class);
        }
        if (null != element && (value = utils.getConstant(element, fieldName)) != null) {
            return value.toString();
        }
        return null;
    }
}

