/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.model;

import org.richfaces.cdk.model.AttributeModel;
import org.richfaces.cdk.model.ClassName;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.FacesId;
import org.richfaces.cdk.model.Merge;
import org.richfaces.cdk.model.ModelElement;
import org.richfaces.cdk.model.ModelElementBase;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.Visitor;
import org.richfaces.cdk.templatecompiler.model.Template;
import org.richfaces.cdk.util.Strings;

public class RendererModel
extends ModelElementBase
implements ModelElement<RendererModel> {
    private static final long serialVersionUID = -5802466539382148578L;
    private FacesId family;
    private String componentType;
    private String templatePath;
    private Template template;
    private boolean rendersChildren;

    public RendererModel() {
    }

    public RendererModel(FacesId type) {
        this.setId(type);
    }

    @Merge
    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    @Merge
    public FacesId getFamily() {
        return this.family;
    }

    public void setFamily(FacesId family) {
        this.family = family;
    }

    public ClassName getRendererClass() {
        return this.getTargetClass();
    }

    public void setRendererClass(ClassName rendererClass) {
        this.setTargetClass(rendererClass);
    }

    public boolean isRendersChildren() {
        return this.rendersChildren;
    }

    public void setRendersChildren(boolean rendersChildren) {
        this.rendersChildren = rendersChildren;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    @Override
    public <R, D> R accept(Visitor<R, D> visitor, D data) {
        return visitor.visitRender(this, data);
    }

    @Override
    public void merge(RendererModel other) {
        ClassName baseClass;
        if (other == null) {
            return;
        }
        ComponentLibrary.merge(this, other);
        ClassName targetClass = this.getTargetClass();
        if (targetClass == null || Strings.isEmpty(targetClass.getName())) {
            this.setTargetClass(other.getTargetClass());
        }
        if ((baseClass = this.getBaseClass()) == null || Strings.isEmpty(baseClass.getName())) {
            this.setTargetClass(other.getBaseClass());
        }
    }

    @Override
    public boolean same(RendererModel other) {
        if (null != this.getId() && null != other.getId()) {
            if (null != this.getFamily() && null != other.getFamily() && !this.getFamily().equals(other.getFamily())) {
                return false;
            }
            return this.getId().equals(other.getId());
        }
        return null != this.getRendererClass() && this.getRendererClass().equals(other.getRendererClass());
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    @Override
    protected PropertyBase createAttribute() {
        return new AttributeModel();
    }

    public String toString() {
        return "Renderer {type: " + this.getId() + ", family: " + this.getFamily() + "}";
    }
}

