/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler;

import com.google.inject.Inject;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.CdkWriter;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.Output;
import org.richfaces.cdk.Outputs;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.model.ComponentModel;
import org.richfaces.cdk.model.ModelSet;
import org.richfaces.cdk.model.PropertyBase;
import org.richfaces.cdk.model.RenderKitModel;
import org.richfaces.cdk.model.RendererModel;
import org.richfaces.cdk.templatecompiler.RendererClassVisitor;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.TemplateVisitorFactory;
import org.richfaces.cdk.templatecompiler.builder.model.JavaClass;
import org.richfaces.cdk.templatecompiler.model.Template;

public class RendererClassGenerator
implements CdkWriter {
    private FileManager output;
    private Logger log;
    private TemplateVisitorFactory<RendererClassVisitor> visitorFactory;
    private FreeMarkerRenderer renderer;

    @Inject
    public RendererClassGenerator(@Output(value=Outputs.JAVA_CLASSES) FileManager output, Logger log, TemplateVisitorFactory<RendererClassVisitor> visitorFactory, @TemplateModel FreeMarkerRenderer renderer) {
        this.output = output;
        this.log = log;
        this.visitorFactory = visitorFactory;
        this.renderer = renderer;
    }

    private ComponentModel findComponentByRenderer(RendererModel renderer, ComponentLibrary library) {
        return library.getComponentByRenderer(renderer.getFamily(), renderer.getId());
    }

    @Override
    public void render(ComponentLibrary library) throws CdkException {
        for (RenderKitModel renderKit : library.getRenderKits()) {
            for (RendererModel renderer : renderKit.getRenderers()) {
                Template template = renderer.getTemplate();
                if (null == template) continue;
                ModelSet<PropertyBase> attributes = ModelSet.create();
                ComponentModel component = this.findComponentByRenderer(renderer, library);
                if (component != null) {
                    attributes.addAll(component.getAttributes());
                }
                attributes.addAll(renderer.getAttributes());
                RendererClassVisitor visitor = this.visitorFactory.createVisitor(template.getInterface(), attributes);
                template.getImplementation().visit(visitor);
                JavaClass javaClass = visitor.getGeneratedClass();
                String fullName = javaClass.getName();
                try {
                    Writer outFile = this.output.createOutput(fullName.replace('.', '/') + ".java", library.lastModified());
                    if (null == outFile) continue;
                    this.renderer.writeTemplate("class.ftl", javaClass, outFile);
                    outFile.close();
                }
                catch (IOException e) {
                    throw new CdkException(e);
                }
                catch (TemplateException e) {
                    throw new CdkException(e);
                }
            }
        }
    }
}

