/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.builder.model;

import java.util.regex.Pattern;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;

public class JavaImportImpl
implements JavaImport {
    private static final Pattern JAVA_LANG_PATTERN = Pattern.compile("^java\\.lang\\.[^\\.]+$");
    private String name;
    private boolean staticImport;

    public JavaImportImpl(String name) {
        this(name, false);
    }

    public JavaImportImpl(Class<?> clazz) {
        this(clazz.getName());
    }

    public JavaImportImpl(String name, boolean staticImport) {
        this.name = name;
        this.staticImport = staticImport;
    }

    public JavaImportImpl(Class<?> clazz, boolean staticImport) {
        this(clazz.getName(), staticImport);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStatic() {
        return this.staticImport;
    }

    @Override
    public boolean isDefault() {
        String name = this.getName();
        if (!name.contains(".")) {
            return true;
        }
        return JAVA_LANG_PATTERN.matcher(name).matches();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isStatic() ? 1231 : 1237);
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaImport other = (JavaImport)obj;
        if (this.isStatic() != other.isStatic()) {
            return false;
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }
}

