/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.builder.model;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.richfaces.cdk.templatecompiler.builder.model.JavaAnnotation;
import org.richfaces.cdk.templatecompiler.builder.model.JavaComment;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.JavaModifier;
import org.richfaces.cdk.templatecompiler.builder.model.RequireImports;

public class JavaLanguageElement
implements RequireImports {
    private boolean hidden = false;
    private Set<JavaModifier> modifiers = new TreeSet<JavaModifier>();
    private List<JavaComment> comments = new ArrayList<JavaComment>();
    private List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
    private String name;

    public JavaLanguageElement() {
    }

    public JavaLanguageElement(String name) {
        this.name = name;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Set<JavaModifier> getModifiers() {
        return this.modifiers;
    }

    public List<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    public List<JavaComment> getComments() {
        return this.comments;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addModifier(JavaModifier modifier) {
        this.modifiers.add(modifier);
    }

    public void addAnnotation(JavaAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public void addComment(JavaComment comment) {
        this.comments.add(comment);
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        Iterable imports = Iterables.concat((Iterable)Iterables.transform(this.getAnnotations(), RequireImports.IMPORTS_TRANSFORM));
        return imports;
    }
}

