/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.types;

import java.text.MessageFormat;
import java.util.Collections;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.PlainClassType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;

public class ReferencedType
implements ELType {
    private String classCodeString;

    public ReferencedType(String classCodeString) {
        this.classCodeString = classCodeString;
    }

    String getClassCodeString() {
        return this.classCodeString;
    }

    @Override
    public String getCode() {
        return this.classCodeString;
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        return Collections.emptyList();
    }

    @Override
    public ELType getRawType() {
        return TypesFactory.OBJECT_TYPE;
    }

    @Override
    public boolean isNullType() {
        return false;
    }

    @Override
    public ELType[] getTypeArguments() {
        return PlainClassType.NO_TYPES;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classCodeString == null ? 0 : this.classCodeString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferencedType other = (ReferencedType)obj;
        return !(this.classCodeString == null ? other.classCodeString != null : !this.classCodeString.equals(other.classCodeString));
    }

    public String toString() {
        return MessageFormat.format("{0}: {1}", this.getClass().getName(), this.getCode());
    }

    @Override
    public ELType getContainerType() {
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isAssignableFrom(ELType anotherType) {
        if (anotherType instanceof ReferencedType) {
            ReferencedType anotherReferencedType = (ReferencedType)anotherType;
            return this.getClassCodeString().equals(anotherReferencedType.getClassCodeString());
        }
        return false;
    }

    @Override
    public String getRawName() {
        return this.getClassCodeString();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

