/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.el.types;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.FacesEvent;
import javax.faces.model.DataModel;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import org.richfaces.cdk.CdkClassLoader;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.ComplexType;
import org.richfaces.cdk.templatecompiler.el.types.DummyPropertyDescriptor;
import org.richfaces.cdk.templatecompiler.el.types.ELPropertyDescriptor;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.PlainClassType;
import org.richfaces.cdk.templatecompiler.el.types.ReferencedType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.util.ArrayUtils;

public final class TypesFactoryImpl
implements TypesFactory {
    static final PropertyDescriptor[] EMPTY_PROPERTY_DESCRIPTORS = new PropertyDescriptor[0];
    static final ImmutableMap<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_CLASSES_MAP = ImmutableMap.builder().put(Boolean.TYPE, Boolean.class).put(Float.TYPE, Float.class).put(Long.TYPE, Long.class).put(Integer.TYPE, Integer.class).put(Short.TYPE, Short.class).put(Byte.TYPE, Byte.class).put(Double.TYPE, Double.class).put(Character.TYPE, Character.class).put(Void.TYPE, Void.class).build();
    static final ImmutableMap<String, Class<?>> PRIMITIVE_CLASSES_MAP;
    private static final Pattern CLASS_SIGNATURE_PATTERN;
    private static final int CLASS_NAME_GROUP_IDX = 1;
    private static final int TYPE_ARGUMENTS_GROUP_IDX = 2;
    private static final int ARRAY_SIGNATURE_GROUP_IDX = 3;
    private static final int ARRAY_SIGNATURE_LENGTH;
    private static final Function<Class<?>, String> PACKAGE_NAME_FUNCTION;
    private static final ImmutableCollection<String> GUESS_PACKAGES;
    private final ClassLoader classLoader;
    private final Logger log;
    private final Map<Type, ELType> reflectionTypesCache = new ConcurrentHashMap<Type, ELType>();
    private final Map<String, ELType> refferencedTypesCache = new ConcurrentHashMap<String, ELType>();
    private final Map<Class<?>, ClassDataHolder> classDataCache = Maps.newHashMap();

    @Inject
    public TypesFactoryImpl(Logger log, CdkClassLoader classLoader) {
        this.log = log;
        this.classLoader = classLoader;
    }

    private ELType getPlainClassType(Class<?> plainClass) {
        ELType plainClassType = this.reflectionTypesCache.get(plainClass);
        if (plainClassType == null) {
            plainClassType = new PlainClassType(plainClass);
            this.reflectionTypesCache.put(plainClass, plainClassType);
        }
        return plainClassType;
    }

    private ELType getReferencedType(String classCodeString) {
        ELType type = this.refferencedTypesCache.get(classCodeString);
        if (type == null) {
            type = new ReferencedType(classCodeString);
            this.refferencedTypesCache.put(classCodeString, type);
        }
        return type;
    }

    private Class<?> tryLoadClas(String className) throws ClassNotFoundException {
        Class<?> result;
        int dotIndex = className.indexOf(46);
        if (dotIndex < 0) {
            for (String guessPackage : GUESS_PACKAGES) {
                String guessTypeName = guessPackage + "." + className;
                try {
                    return Class.forName(guessTypeName, false, this.classLoader);
                }
                catch (ClassNotFoundException e) {
                }
                catch (LinkageError e) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info((CharSequence)MessageFormat.format("Class {0} couldn''t be loaded because of: {1}", guessTypeName, e.getMessage()));
                }
            }
        }
        if ((result = (Class<?>)PRIMITIVE_CLASSES_MAP.get((Object)className)) == null) {
            try {
                result = Class.forName(className, false, this.classLoader);
            }
            catch (LinkageError e) {
                String errorMessage = MessageFormat.format("Class {0} couldn''t be loaded because of: {1}", className, e.getMessage());
                if (this.log.isInfoEnabled()) {
                    this.log.info((CharSequence)errorMessage);
                }
                throw new ClassNotFoundException(errorMessage, e);
            }
        }
        return result;
    }

    ELType[] parseTypeArgumentsString(String typeArguments) {
        if (typeArguments == null) {
            return PlainClassType.NO_TYPES;
        }
        String[] typeArgumentsSplit = typeArguments.trim().split(",");
        ELType[] types = new ELType[typeArgumentsSplit.length];
        for (int i = 0; i < typeArgumentsSplit.length; ++i) {
            types[i] = this.getType(typeArgumentsSplit[i]);
        }
        return types;
    }

    @Override
    public ELType getType(String typeString) {
        Matcher matcher = CLASS_SIGNATURE_PATTERN.matcher(typeString);
        boolean matchResult = matcher.matches();
        if (matchResult) {
            ELType baseType;
            String className = matcher.group(1).trim();
            String typeArgumentsString = matcher.group(2);
            Object[] typeArguments = this.parseTypeArgumentsString(typeArgumentsString);
            String arraySignature = matcher.group(3);
            int arrayDepth = 0;
            if (arraySignature != null) {
                arrayDepth = arraySignature.replaceAll("\\s+", "").length() / ARRAY_SIGNATURE_LENGTH;
            }
            try {
                Class<?> loadedClas = this.tryLoadClas(className);
                baseType = this.getType(loadedClas);
            }
            catch (ClassNotFoundException e) {
                baseType = this.getReferencedType(className);
            }
            if (arrayDepth != 0 || !ArrayUtils.isEmpty(typeArguments)) {
                return new ComplexType(baseType, (ELType[])typeArguments, arrayDepth);
            }
            return baseType;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((CharSequence)MessageFormat.format("Cannot parse type signature: ''{0}''", typeString));
        }
        return this.getReferencedType(typeString);
    }

    ELType createType(Type reflectionType) {
        Object[] actualTypeArguments = null;
        Class<?> rawType = null;
        int arrayDepth = 0;
        Type localReflectionType = reflectionType;
        while (localReflectionType instanceof GenericArrayType) {
            localReflectionType = ((GenericArrayType)localReflectionType).getGenericComponentType();
            ++arrayDepth;
        }
        if (localReflectionType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)localReflectionType;
            actualTypeArguments = parameterizedType.getActualTypeArguments();
            rawType = (Class)parameterizedType.getRawType();
        } else if (localReflectionType instanceof Class) {
            rawType = (Class<?>)localReflectionType;
        }
        if (rawType != null) {
            while (rawType.isArray()) {
                ++arrayDepth;
                rawType = rawType.getComponentType();
            }
            Object[] typeArguments = PlainClassType.NO_TYPES;
            if (!ArrayUtils.isEmpty(actualTypeArguments)) {
                typeArguments = this.getTypesArray((Type[])actualTypeArguments);
            }
            ELType clearComponentType = this.getPlainClassType(rawType);
            if (!ArrayUtils.isEmpty(typeArguments) || arrayDepth != 0) {
                return new ComplexType(clearComponentType, (ELType[])typeArguments, arrayDepth);
            }
            return clearComponentType;
        }
        return this.getReferencedType(reflectionType.toString());
    }

    @Override
    public ELType getType(Type reflectionType) {
        ELType result = this.reflectionTypesCache.get(reflectionType);
        if (result == null) {
            result = this.createType(reflectionType);
            this.reflectionTypesCache.put(reflectionType, result);
        }
        return result;
    }

    private ELType[] getTypesArray(Type[] reflectionTypes) {
        ELType[] types = new ELType[reflectionTypes.length];
        for (int i = 0; i < reflectionTypes.length; ++i) {
            types[i] = this.getType(reflectionTypes[i]);
        }
        return types;
    }

    static Class<?> getWrapperClass(Class<?> inClazz) {
        if (inClazz.isPrimitive()) {
            return (Class)PRIMITIVE_TO_WRAPPER_CLASSES_MAP.get(inClazz);
        }
        return inClazz;
    }

    private ClassDataHolder resolveClassPropertiesAndMethods(Class<?> clazz) throws ParsingException {
        ClassDataHolder classDataHolder = this.classDataCache.get(clazz);
        if (classDataHolder == null) {
            classDataHolder = new ClassDataHolder(this);
            new ClassWalkingLogic(clazz).walk(classDataHolder);
            this.classDataCache.put(clazz, classDataHolder);
        }
        return classDataHolder;
    }

    @Override
    public ELPropertyDescriptor getPropertyDescriptor(ELType elType, String propertyName) throws ParsingException {
        ClassDataHolder classDataHolder;
        Map<String, ELPropertyDescriptor> resolvedProperties;
        ELPropertyDescriptor propertyDescriptor = elType == null ? new DummyPropertyDescriptor(propertyName) : ((resolvedProperties = (classDataHolder = this.resolveClassPropertiesAndMethods(TypesFactoryImpl.getClassFromType(elType))).getResolvedProperties()).containsKey(propertyName) ? resolvedProperties.get(propertyName) : new DummyPropertyDescriptor(propertyName));
        return propertyDescriptor;
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) throws ParsingException {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] descriptors = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
            descriptors = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            return EMPTY_PROPERTY_DESCRIPTORS;
        }
        if (descriptors == null) {
            descriptors = EMPTY_PROPERTY_DESCRIPTORS;
        }
        return descriptors;
    }

    private static boolean isMethodVisible(Method method) {
        return !Modifier.isPrivate(method.getModifiers());
    }

    private static Class<?> getClassFromType(ELType elType) {
        if (elType == null) {
            return Object.class;
        }
        if (elType instanceof PlainClassType) {
            Class<?> clazz = ((PlainClassType)elType).getPlainJavaClass();
            return clazz;
        }
        if (elType instanceof ComplexType) {
            return TypesFactoryImpl.getClassFromType(elType.getRawType());
        }
        return Object.class;
    }

    @Override
    public ELType getMatchingVisibleMethodReturnType(ELType elType, String methodName, ELType ... parameterTypes) throws ParsingException {
        ClassDataHolder classDataHolder = this.resolveClassPropertiesAndMethods(TypesFactoryImpl.getClassFromType(elType));
        List<Method> resolvedMethods = classDataHolder.getResolvedMethods();
        int paramSize = parameterTypes.length;
        Method bestMatch = null;
        for (Method resolvedMethod : resolvedMethods) {
            ELType[] methodsParams;
            int methodParamSize;
            if (!TypesFactoryImpl.isMethodVisible(resolvedMethod) || !resolvedMethod.getName().equals(methodName) || (methodParamSize = (methodsParams = this.getTypesArray(resolvedMethod.getParameterTypes())).length) != paramSize) continue;
            boolean match = true;
            for (int n = 0; n < methodParamSize; ++n) {
                if (methodsParams[n].isAssignableFrom(parameterTypes[n])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            bestMatch = resolvedMethod;
        }
        if (bestMatch != null) {
            return this.getType(bestMatch.getGenericReturnType());
        }
        return TypesFactory.OBJECT_TYPE;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Class primitiveClass : PRIMITIVE_TO_WRAPPER_CLASSES_MAP.keySet()) {
            builder.put((Object)primitiveClass.getName(), (Object)primitiveClass);
        }
        PRIMITIVE_CLASSES_MAP = builder.build();
        CLASS_SIGNATURE_PATTERN = Pattern.compile("^\\s*([^\\[<]+)\\s*(?:<\\s*(.*)\\s*>)?\\s*((?:\\[\\s*\\]\\s*)+)?\\s*$");
        ARRAY_SIGNATURE_LENGTH = "[]".length();
        PACKAGE_NAME_FUNCTION = new Function<Class<?>, String>(){

            public String apply(Class<?> from) {
                return from.getPackage().getName();
            }
        };
        GUESS_PACKAGES = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)ImmutableSet.of(UIComponent.class, Behavior.class, Converter.class, Validator.class, FacesContext.class, Application.class, (Object[])new Class[]{FacesEvent.class, DataModel.class, Renderer.class, Collection.class, Object.class}), PACKAGE_NAME_FUNCTION));
    }

    static class ClassWalkingLogic {
        private Queue<Class<?>> classesList = new LinkedList();
        private Set<Class<?>> visitedClasses = new HashSet();

        public ClassWalkingLogic(Class<?> clazz) {
            this.classesList.add(clazz);
        }

        public void walk(ClassVisitor visitor) throws ParsingException {
            while (!this.classesList.isEmpty()) {
                Class<?>[] interfaces;
                Class<?> clazz = this.classesList.remove();
                if (!this.visitedClasses.add(clazz)) continue;
                visitor.visit(clazz);
                Class<?> superclass = clazz.getSuperclass();
                if (superclass != null && !this.visitedClasses.contains(superclass)) {
                    this.classesList.add(superclass);
                }
                if ((interfaces = clazz.getInterfaces()) == null) continue;
                for (Class<?> iface : interfaces) {
                    if (this.visitedClasses.contains(iface)) continue;
                    this.classesList.add(iface);
                }
            }
            if (this.visitedClasses.add(Object.class)) {
                visitor.visit(Object.class);
            }
            this.visitedClasses.clear();
        }
    }

    static interface ClassVisitor {
        public void visit(Class<?> var1) throws ParsingException;
    }

    private static final class ClassDataHolder
    implements ClassVisitor {
        private Map<String, ELPropertyDescriptor> resolvedProperties;
        private List<Method> resolvedMethods;
        private final TypesFactory typesFactory;

        public ClassDataHolder(TypesFactory typesFactory) {
            this.typesFactory = typesFactory;
            this.resolvedProperties = Maps.newHashMap();
            this.resolvedMethods = Lists.newArrayList();
        }

        public Map<String, ELPropertyDescriptor> getResolvedProperties() {
            return this.resolvedProperties;
        }

        public List<Method> getResolvedMethods() {
            return this.resolvedMethods;
        }

        @Override
        public void visit(Class<?> clazz) throws ParsingException {
            Method[] declaredMethods;
            PropertyDescriptor[] pds;
            try {
                pds = TypesFactoryImpl.getPropertyDescriptors(clazz);
                declaredMethods = clazz.getDeclaredMethods();
            }
            catch (LinkageError e) {
                throw new ParsingException(e.getMessage(), e);
            }
            for (PropertyDescriptor descriptor : pds) {
                String descriptorName = descriptor.getName();
                if (this.resolvedProperties.get(descriptorName) != null) continue;
                Type reflectionType = null != descriptor.getReadMethod() ? descriptor.getReadMethod().getGenericReturnType() : (null != descriptor.getWriteMethod() ? descriptor.getWriteMethod().getGenericParameterTypes()[0] : descriptor.getPropertyType());
                ELType propertyType = this.typesFactory.getType(reflectionType);
                JavaELPropertyDescriptor elDescriptor = new JavaELPropertyDescriptor(descriptor, propertyType);
                this.resolvedProperties.put(descriptorName, elDescriptor);
            }
            this.resolvedMethods.addAll(Arrays.asList(declaredMethods));
        }
    }

    private static final class JavaELPropertyDescriptor
    implements ELPropertyDescriptor {
        private final PropertyDescriptor descriptor;
        private final String descriptorName;
        private final ELType propertyType;

        public JavaELPropertyDescriptor(PropertyDescriptor descriptor, ELType propertyType) {
            this.descriptor = descriptor;
            this.propertyType = propertyType;
            this.descriptorName = descriptor.getName();
        }

        @Override
        public boolean isWritable() {
            return null != this.descriptor.getWriteMethod();
        }

        @Override
        public boolean isReadable() {
            return null != this.descriptor.getReadMethod();
        }

        @Override
        public String getWriteMethosName() {
            return this.descriptor.getWriteMethod().getName();
        }

        @Override
        public ELType getType() {
            return this.propertyType;
        }

        @Override
        public String getReadMethodName() {
            return this.descriptor.getReadMethod().getName();
        }

        @Override
        public String getName() {
            return this.descriptorName;
        }
    }
}

