/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.RequireImports;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.TemplateStatement;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;

public class ScriptObjectStatement
extends FreeMarkerTemplateStatementBase {
    private String name;
    private ELParser parser;
    private TypedTemplateStatement base;
    private Logger logger;
    private TypesFactory typesFactory;
    private ELType mapType;
    private ELType mapImplementationType;

    @Inject
    public ScriptObjectStatement(@TemplateModel FreeMarkerRenderer renderer, ELParser parser, Logger logger, TypesFactory typesFactory) {
        super(renderer, "script-object");
        this.parser = parser;
        this.logger = logger;
        this.typesFactory = typesFactory;
    }

    public TemplateStatement getBaseExpression() {
        return this.base;
    }

    public String getName() {
        return this.name;
    }

    public ELType getType() {
        return this.mapType;
    }

    public ELType getImplementationType() {
        return this.mapImplementationType;
    }

    public void setObject(String name, String baseExpression) {
        this.mapType = this.typesFactory.getType("Map<String, Object>");
        this.mapImplementationType = this.typesFactory.getType("LinkedHashMap<String, Object>");
        this.name = name;
        if (!Strings.isNullOrEmpty((String)baseExpression)) {
            try {
                this.base = this.parser.parse(baseExpression, (Variables)this, this.getType());
                this.base.setParent(this);
            }
            catch (ParsingException e) {
                this.logger.error((CharSequence)"Error parse scriptObject statement expression", (Throwable)e);
            }
        }
        this.setVariable(name, this.getType());
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        return Iterables.concat(super.getRequiredImports(), this.mapImplementationType.getRequiredImports(), this.mapType.getRequiredImports(), (Iterable)((Iterable)RequireImports.IMPORTS_TRANSFORM.apply((Object)this.base)));
    }

    @Override
    public Iterable<HelperMethod> getRequiredMethods() {
        return Iterables.concat(super.getRequiredMethods(), (Iterable)((Iterable)METHODS_TRANSFORM.apply((Object)this.base)));
    }

    @Override
    public Iterable<JavaField> getRequiredFields() {
        return Iterables.concat(super.getRequiredFields(), (Iterable)((Iterable)TemplateStatement.FIELDS_TRANSFORM.apply((Object)this.base)));
    }
}

