/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.TemplateStatement;

public class StatementsContainer
implements TemplateStatement,
Variables {
    private static final Function<TemplateStatement, Iterable<JavaImport>> IMPORTS_TRANSFORM = new Function<TemplateStatement, Iterable<JavaImport>>(){

        public Iterable<JavaImport> apply(TemplateStatement from) {
            return from.getRequiredImports();
        }
    };
    private static final Function<TemplateStatement, Iterable<JavaField>> FIELDS_TRANSFORM = new Function<TemplateStatement, Iterable<JavaField>>(){

        public Iterable<JavaField> apply(TemplateStatement from) {
            return from.getRequiredFields();
        }
    };
    private static final Function<TemplateStatement, Iterable<HelperMethod>> HELPER_METHODS_TRANSFORM = new Function<TemplateStatement, Iterable<HelperMethod>>(){

        public Iterable<HelperMethod> apply(TemplateStatement from) {
            return from.getRequiredMethods();
        }
    };
    private final List<TemplateStatement> statements = new ArrayList<TemplateStatement>(){

        @Override
        public boolean add(TemplateStatement e) {
            e.setParent(StatementsContainer.this);
            return super.add(e);
        }

        @Override
        public void add(int index, TemplateStatement element) {
            element.setParent(StatementsContainer.this);
            super.add(index, element);
        }
    };
    private StatementsContainer parent;
    private final Map<String, ELType> localVariablesMap = Maps.newHashMap();

    public List<TemplateStatement> getStatements() {
        return this.statements;
    }

    public void addStatement(TemplateStatement statement) {
        this.getStatements().add(statement);
    }

    public void addStatement(int index, TemplateStatement statement) {
        this.getStatements().add(index, statement);
    }

    @Override
    public void setParent(StatementsContainer parent) {
        this.parent = parent;
    }

    public StatementsContainer getParent() {
        return this.parent;
    }

    public boolean isEmpty() {
        return this.getStatements().isEmpty();
    }

    @Override
    public String getCode() {
        StringBuilder sb = new StringBuilder();
        for (TemplateStatement statement : this.getStatements()) {
            sb.append(statement.getCode());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public ELType getVariable(String name) {
        ELType type = this.localVariablesMap.get(name);
        if (null == type && null != this.parent) {
            type = this.parent.getVariable(name);
        }
        return type;
    }

    @Override
    public boolean isDefined(String name) {
        boolean defined = this.localVariablesMap.containsKey(name);
        if (!defined && null != this.parent) {
            defined = this.parent.isDefined(name);
        }
        return defined;
    }

    @Override
    public ELType setVariable(String name, ELType type) {
        ELType variable = this.getVariable(name);
        this.localVariablesMap.put(name, type);
        return variable;
    }

    private <T> Iterable<T> concatStatements(Function<TemplateStatement, Iterable<T>> transform) {
        Iterable imports = Iterables.concat((Iterable)Iterables.transform(this.getStatements(), transform));
        return imports;
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        return this.concatStatements(IMPORTS_TRANSFORM);
    }

    @Override
    public Iterable<JavaField> getRequiredFields() {
        return this.concatStatements(FIELDS_TRANSFORM);
    }

    @Override
    public Iterable<HelperMethod> getRequiredMethods() {
        return this.concatStatements(HELPER_METHODS_TRANSFORM);
    }
}

