/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.JavaField;
import org.richfaces.cdk.templatecompiler.builder.model.JavaImport;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.HelperMethod;
import org.richfaces.cdk.templatecompiler.statements.TemplateStatement;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;

public class SwitchStatement
extends FreeMarkerTemplateStatementBase {
    private String keyExpression;
    private final ELParser parser;
    private final Logger log;
    private TypedTemplateStatement statement;

    @Inject
    public SwitchStatement(@TemplateModel FreeMarkerRenderer renderer, ELParser parser, Logger log) {
        super(renderer, "switch");
        this.parser = parser;
        this.log = log;
    }

    public TemplateStatement getKeyExpression() {
        return this.statement;
    }

    public void setKeyExpression(String keyExpression) {
        try {
            this.keyExpression = keyExpression;
            this.statement = this.parser.parse(keyExpression, (Variables)this, TypesFactory.OBJECT_TYPE);
            this.statement.setParent(this);
        }
        catch (ParsingException e) {
            this.log.error((CharSequence)"Error parse switch statement expression", (Throwable)e);
        }
    }

    @Override
    public Iterable<JavaImport> getRequiredImports() {
        return Iterables.concat(super.getRequiredImports(), this.statement.getRequiredImports());
    }

    @Override
    public Iterable<HelperMethod> getRequiredMethods() {
        return Iterables.concat(super.getRequiredMethods(), this.statement.getRequiredMethods());
    }

    @Override
    public Iterable<JavaField> getRequiredFields() {
        return Iterables.concat(super.getRequiredFields(), this.statement.getRequiredFields());
    }
}

