/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.templatecompiler.statements;

import com.google.inject.Inject;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.generate.freemarker.FreeMarkerRenderer;
import org.richfaces.cdk.templatecompiler.ELParser;
import org.richfaces.cdk.templatecompiler.TemplateModel;
import org.richfaces.cdk.templatecompiler.builder.model.Variables;
import org.richfaces.cdk.templatecompiler.el.ParsingException;
import org.richfaces.cdk.templatecompiler.el.types.ELType;
import org.richfaces.cdk.templatecompiler.el.types.TypesFactory;
import org.richfaces.cdk.templatecompiler.statements.FreeMarkerTemplateStatementBase;
import org.richfaces.cdk.templatecompiler.statements.TypedTemplateStatement;

public class WriteAttributeStatement
extends FreeMarkerTemplateStatementBase {
    private QName attributeName;
    private TypedTemplateStatement valueExpression;
    private final ELParser parser;
    private final Logger log;
    private String defaultValue;
    private Iterable<String> events = Collections.emptyList();

    @Inject
    public WriteAttributeStatement(@TemplateModel FreeMarkerRenderer renderer, ELParser parser, Logger log) {
        super(renderer, "write-attribute");
        this.parser = parser;
        this.log = log;
    }

    public void setAttribute(QName qName, Object object, String defaultValue) {
        this.defaultValue = defaultValue;
        this.setAttributeName(qName);
        this.parseExpression(object, TypesFactory.OBJECT_TYPE);
    }

    public void setUriAttribute(QName qName, Object value, String defaultValue) {
        this.setTemplateName("write-uri-attribute");
        this.setAttribute(qName, value, defaultValue);
    }

    public void setBooleanAttribute(QName qName, Object value, String defaultValue) {
        this.setTemplateName("write-boolean-attribute");
        this.setAttribute(qName, value, defaultValue);
    }

    private void parseExpression(Object object, ELType objectType) {
        try {
            this.valueExpression = this.parser.parse(object.toString(), (Variables)this, objectType);
            this.addStatement(this.valueExpression);
        }
        catch (ParsingException e) {
            this.log.error((CharSequence)("Error parsing expression for attribute " + this.getAttributeName()), (Throwable)e);
        }
    }

    private void setAttributeName(QName qName) {
        this.attributeName = qName;
    }

    public QName getAttributeName() {
        return this.attributeName;
    }

    public TypedTemplateStatement getValue() {
        return this.valueExpression;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setEvents(Iterable<String> iterable) {
        this.events = iterable;
    }

    public Iterable<String> getEvents() {
        return this.events;
    }
}

