/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.xmlconfig.JAXBBinding;

public final class JavaUtils {
    public static final ImmutableMap<Class<?>, Class<?>> BOXING_CLASSES = ImmutableMap.builder().put(Boolean.TYPE, Boolean.class).put(Character.TYPE, Character.class).put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).build();
    public static final Function<Class<?>, String> CLASS_TO_CLASS_NAME = new Function<Class<?>, String>(){

        public String apply(Class<?> from) {
            return from.getName();
        }
    };

    private JavaUtils() {
    }

    private static String toCharExpression(char c) {
        String prependingZeroesString;
        String hexString = Integer.toHexString(c);
        switch (hexString.length()) {
            case 1: {
                prependingZeroesString = "000";
                break;
            }
            case 2: {
                prependingZeroesString = "00";
                break;
            }
            case 3: {
                prependingZeroesString = "0";
                break;
            }
            case 4: {
                prependingZeroesString = "";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return "\\u" + prependingZeroesString + hexString.toUpperCase(Locale.US);
    }

    public static String getEscapedString(String s) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        result.append('\"');
        for (char c : chars = s.toCharArray()) {
            if (c == '\n') {
                result.append("\\n");
                continue;
            }
            if (c == '\r') {
                result.append("\\r");
                continue;
            }
            if (c == '\t') {
                result.append("\\t");
                continue;
            }
            if (c == '\f') {
                result.append("\\f");
                continue;
            }
            if (c == '\b') {
                result.append("\\b");
                continue;
            }
            if (c == '\\') {
                result.append("\\\\");
                continue;
            }
            if (c == '\"') {
                result.append("\\\"");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                result.append(JavaUtils.toCharExpression(c));
                continue;
            }
            result.append(c);
        }
        result.append('\"');
        return result.toString();
    }

    public static String getEscapedStringsArray(Iterable<String> strings) {
        StringBuilder sb = new StringBuilder();
        if (strings != null) {
            for (String string : strings) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(JavaUtils.getEscapedString(string));
            }
        }
        return sb.toString();
    }

    public static boolean isalnum(char c) {
        return JavaUtils.isalpha(c) || JavaUtils.isdigit(c);
    }

    public static boolean isalpha(char c) {
        return JavaUtils.isupper(c) || JavaUtils.islower(c);
    }

    public static boolean isupper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean islower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isdigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static Class<?> toBoxingClass(Class<?> targetType) {
        if (targetType.isPrimitive()) {
            return (Class)BOXING_CLASSES.get(targetType);
        }
        return targetType;
    }

    public static void copyProperties(Object source, Object destination) throws CdkException {
        try {
            PropertyDescriptor[] targetProperties = Introspector.getBeanInfo(destination.getClass()).getPropertyDescriptors();
            PropertyDescriptor[] sourceProperties = Introspector.getBeanInfo(source.getClass()).getPropertyDescriptors();
            for (PropertyDescriptor targetProperty : targetProperties) {
                String name = targetProperty.getName();
                for (PropertyDescriptor sourceProperty : sourceProperties) {
                    if (JAXBBinding.IGNORE_PROPERTIES.contains((Object)name) || !name.equals(sourceProperty.getName())) continue;
                    try {
                        JavaUtils.writeProperty(source, destination, targetProperty, sourceProperty);
                    }
                    catch (Exception e) {
                        throw new CdkException("Error on copying property " + name + " from object " + source.getClass() + " to " + destination.getClass(), e);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CdkException("Properties copying error", e);
        }
    }

    public static void writeProperty(Object source, Object destination, PropertyDescriptor targetProperty, PropertyDescriptor sourceProperty) throws IllegalAccessException, InvocationTargetException {
        Method readMethod = sourceProperty.getReadMethod();
        if (readMethod == null) {
            return;
        }
        Object propertyValue = readMethod.invoke(source, new Object[0]);
        if (propertyValue != null) {
            Class<?> targetType = targetProperty.getPropertyType();
            targetType = JavaUtils.toBoxingClass(targetType);
            Class<?> sourceType = sourceProperty.getPropertyType();
            sourceType = JavaUtils.toBoxingClass(sourceType);
            Method writeMethod = targetProperty.getWriteMethod();
            if (JAXBBinding.isCollections(targetType, propertyValue)) {
                Collection targetCollection = (Collection)targetProperty.getReadMethod().invoke(destination, new Object[0]);
                if (null != targetCollection) {
                    targetCollection.addAll((Collection)propertyValue);
                } else if (writeMethod != null) {
                    writeMethod.invoke(destination, propertyValue);
                }
            } else if (writeMethod != null) {
                if (targetType.equals(sourceType)) {
                    writeMethod.invoke(destination, propertyValue);
                } else if (targetType.equals(String.class)) {
                    writeMethod.invoke(destination, propertyValue.toString());
                }
            }
        }
    }
}

