/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.xmlconfig;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileNotFoundException;
import org.richfaces.cdk.CdkException;
import org.richfaces.cdk.FileManager;
import org.richfaces.cdk.Logger;
import org.richfaces.cdk.ModelBuilder;
import org.richfaces.cdk.Source;
import org.richfaces.cdk.Sources;
import org.richfaces.cdk.model.ComponentLibrary;
import org.richfaces.cdk.util.JavaUtils;
import org.richfaces.cdk.xmlconfig.JAXB;
import org.richfaces.cdk.xmlconfig.model.FacesConfigAdapter;
import org.richfaces.cdk.xmlconfig.model.FacesConfigBean;

public class FacesConfigParser
implements ModelBuilder {
    private static final FacesConfigAdapter ADAPTER = new FacesConfigAdapter();
    @Inject
    private Logger log;
    @Inject
    private JAXB jaxbBinding;
    @Inject
    private ComponentLibrary library;
    @Inject
    @Source(value=Sources.FACES_CONFIGS)
    private FileManager configFiles;

    @Override
    public void build() throws CdkException {
        for (File file : this.configFiles.getFiles()) {
            try {
                FacesConfigBean unmarshal = this.unmarshalFacesConfig(file);
                if (null == unmarshal) continue;
                ComponentLibrary facesConfig = (ComponentLibrary)ADAPTER.unmarshal(unmarshal);
                this.library.getComponents().addAll(facesConfig.getComponents());
                this.library.getRenderKits().addAll(facesConfig.getRenderKits());
                this.library.getConverters().addAll(facesConfig.getConverters());
                this.library.getValidators().addAll(facesConfig.getValidators());
                this.library.getBehaviors().addAll(facesConfig.getBehaviors());
                this.library.getFunctions().addAll(facesConfig.getFunctions());
                this.library.getEvents().addAll(facesConfig.getEvents());
                if (null != unmarshal.getMetadataComplete()) {
                    this.library.setMetadataComplete(unmarshal.getMetadataComplete());
                }
                this.library.getExtension().getExtensions().addAll(facesConfig.getExtension().getExtensions());
                if (null != facesConfig.getTaglib()) {
                    if (null == this.library.getTaglib()) {
                        this.library.setTaglib(facesConfig.getTaglib());
                    } else {
                        JavaUtils.copyProperties(facesConfig.getTaglib(), this.library.getTaglib());
                    }
                }
                if (null == facesConfig.getPrefix()) continue;
                this.library.setPrefix(facesConfig.getPrefix());
            }
            catch (FileNotFoundException e) {
                this.log.error((CharSequence)"faces-config not found", (Throwable)e);
            }
        }
    }

    protected FacesConfigBean unmarshalFacesConfig(File file) throws CdkException, FileNotFoundException {
        return this.jaxbBinding.unmarshal(file, "http://java.sun.com/xml/ns/javaee/web-facesconfig_2_0.xsd", FacesConfigBean.class);
    }
}

