/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor;

import java.io.PrintStream;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

class JavaScriptErrorReporter
implements ErrorReporter {
    private boolean reportWarnings;
    private PrintStream err;

    JavaScriptErrorReporter(PrintStream err, boolean reportWarnings) {
        this.err = err;
        this.reportWarnings = reportWarnings;
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (this.reportWarnings) {
            this.reportMessage(message, sourceName, line, lineSource, lineOffset);
        }
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.error(message, sourceName, line, lineSource, lineOffset);
        return new EvaluatorException(message);
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.reportMessage(message, sourceName, line, lineSource, lineOffset);
    }

    private void reportMessage(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            if (message.length() == 0) {
                this.err.println("An unknown error occurred...");
            } else {
                this.err.println(message);
            }
        } else {
            this.err.println(line + 58 + lineOffset + 58 + message);
        }
    }
}

