/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.writer.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.faces.application.Resource;
import org.apache.maven.plugin.logging.Log;
import org.richfaces.cdk.ResourceWriter;
import org.richfaces.cdk.resource.util.ResourceConstants;
import org.richfaces.cdk.resource.util.ResourceUtil;
import org.richfaces.cdk.resource.writer.ResourceProcessor;
import org.richfaces.cdk.resource.writer.impl.ThroughputResourceProcessor;
import org.richfaces.cdk.strings.Constants;
import org.richfaces.resource.ResourceKey;

public class ResourceWriterImpl
implements ResourceWriter {
    private final Map<String, FileOutputStream> PACKED = new LinkedHashMap<String, FileOutputStream>();
    private File resourceContentsDir;
    private Map<String, String> processedResources = Maps.newConcurrentMap();
    private Iterable<ResourceProcessor> resourceProcessors;
    private Log log;
    private long currentTime;
    private Set<ResourceKey> resourcesWithKnownOrder;
    private Set<ResourceKey> packedResources = Sets.newHashSet();

    public ResourceWriterImpl(File resourceContentsDir, Iterable<ResourceProcessor> resourceProcessors, Log log, Set<ResourceKey> resourcesWithKnownOrder) {
        this.resourceContentsDir = resourceContentsDir;
        this.resourceProcessors = Iterables.concat(resourceProcessors, Collections.singleton(ThroughputResourceProcessor.INSTANCE));
        this.log = log;
        this.resourcesWithKnownOrder = resourcesWithKnownOrder;
        resourceContentsDir.mkdirs();
        this.currentTime = System.currentTimeMillis();
    }

    private synchronized File createOutputFile(String path) throws IOException {
        File outFile = new File(this.resourceContentsDir, path);
        outFile.getParentFile().mkdirs();
        if (outFile.exists()) {
            if (outFile.lastModified() > this.currentTime) {
                this.log.warn((CharSequence)MessageFormat.format("File {0} already exists and will be overwritten", outFile.getPath()));
            }
            outFile.delete();
        }
        if (!outFile.createNewFile()) {
            this.log.warn((CharSequence)MessageFormat.format("Could not create {0} file", outFile.getPath()));
        }
        return outFile;
    }

    @Override
    public void writeResource(String skinName, Resource resource) throws IOException {
        String requestPath;
        String requestPathWithSkin = requestPath = resource.getRequestPath();
        if (requestPath.startsWith("%skin%/")) {
            requestPathWithSkin = Constants.SLASH_JOINER.join((Object)skinName, (Object)requestPath.substring("%skin%/".length()), new Object[0]);
        }
        ResourceProcessor matchingProcessor = this.getMatchingResourceProcessor(requestPath);
        File outFile = this.createOutputFile(requestPathWithSkin);
        this.log.debug((CharSequence)("Opening output stream for " + outFile));
        matchingProcessor.process(requestPathWithSkin, new ResourceInputStreamSupplier(resource), (OutputSupplier<? extends OutputStream>)Files.newOutputStreamSupplier((File)outFile), true);
        this.processedResources.put(ResourceUtil.getResourceQualifier(resource), requestPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePackedResource(String skinName, Resource resource) throws IOException {
        FileOutputStream outputStream;
        String requestPath = resource.getRequestPath();
        String extension = this.getExtension(requestPath);
        ResourceKey resourceKey = new ResourceKey(resource.getResourceName(), resource.getLibraryName());
        if (!"js".equals(extension) && !"css".equals(extension)) {
            this.writeResource(skinName, resource);
            return;
        }
        if (!this.resourcesWithKnownOrder.contains(resourceKey)) {
            this.writeResource(skinName, resource);
            return;
        }
        String requestPathWithSkinVariable = "packed/packed." + extension;
        if (skinName != null && skinName.length() > 0) {
            requestPathWithSkinVariable = "%skin%/" + requestPathWithSkinVariable;
        }
        String requestPathWithSkin = Constants.SLASH_JOINER.join((Object)skinName, (Object)"packed", new Object[]{"packed." + extension});
        ResourceProcessor matchingProcessor = this.getMatchingResourceProcessor(requestPathWithSkin);
        Object object = this.PACKED;
        synchronized (object) {
            String packagingCacheKey = extension + ":" + skinName;
            if (!this.PACKED.containsKey(packagingCacheKey)) {
                File outFile = this.createOutputFile(requestPathWithSkin);
                this.log.debug((CharSequence)("Opening shared output stream for " + outFile));
                outputStream = (FileOutputStream)Files.newOutputStreamSupplier((File)outFile, (boolean)true).getOutput();
                this.PACKED.put(packagingCacheKey, outputStream);
            }
            outputStream = this.PACKED.get(packagingCacheKey);
        }
        object = outputStream;
        synchronized (object) {
            matchingProcessor.process(requestPathWithSkin, new ResourceInputStreamSupplier(resource).getInput(), outputStream, false);
        }
        this.processedResources.put(ResourceUtil.getResourceQualifier(resource), requestPathWithSkinVariable);
        this.packedResources.add(resourceKey);
        if (ResourceUtil.isSameResource(resource, ResourceConstants.JSF_UNCOMPRESSED) || ResourceUtil.isSameResource(resource, ResourceConstants.JSF_COMPRESSED)) {
            this.processedResources.put(ResourceUtil.getResourceQualifier(ResourceConstants.JSF_COMPRESSED), requestPathWithSkinVariable);
            this.processedResources.put(ResourceUtil.getResourceQualifier(ResourceConstants.JSF_UNCOMPRESSED), requestPathWithSkinVariable);
        }
    }

    private ResourceProcessor getMatchingResourceProcessor(final String requestPath) {
        return (ResourceProcessor)Iterables.get((Iterable)Iterables.filter(this.resourceProcessors, (Predicate)new Predicate<ResourceProcessor>(){

            public boolean apply(ResourceProcessor input) {
                return input.isSupportedFile(requestPath);
            }
        }), (int)0);
    }

    private String getExtension(String requestPath) {
        int extensionIndex = Math.max(requestPath.lastIndexOf(46), requestPath.lastIndexOf(47));
        return requestPath.substring(extensionIndex + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeProcessedResourceMappings(String staticResourceMappingFile) throws IOException {
        FileOutputStream fos = null;
        try {
            File mappingsFile = new File(staticResourceMappingFile);
            mappingsFile.delete();
            mappingsFile.getParentFile().mkdirs();
            mappingsFile.createNewFile();
            fos = new FileOutputStream(mappingsFile);
            Properties properties = new Properties();
            properties.putAll(this.processedResources);
            properties.store(fos, null);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static final class ResourceInputStreamSupplier
    implements InputSupplier<InputStream> {
        private Resource resource;

        public ResourceInputStreamSupplier(Resource resource) {
            this.resource = resource;
        }

        public InputStream getInput() throws IOException {
            return this.resource.getInputStream();
        }
    }
}

