/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.util.dom;

import java.util.HashMap;
import java.util.Map;

final class ElementInfo {
    Map<String, String> namespaceDeclarations = null;
    String localName;
    String namespaceURI;
    ElementInfo parent;
    String qName;

    public ElementInfo(ElementInfo parent) {
        this.parent = parent;
    }

    public void put(String prefix, String namespaceURI) {
        if (this.namespaceDeclarations == null) {
            this.namespaceDeclarations = new HashMap<String, String>();
        }
        this.namespaceDeclarations.put(prefix, namespaceURI);
    }

    public String getPrefix(String namespaceURI) {
        if (this.namespaceDeclarations == null || this.namespaceDeclarations.size() == 0) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.namespaceDeclarations.entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (this.namespaceDeclarations == null || this.namespaceDeclarations.size() == 0) {
            return null;
        }
        return this.namespaceDeclarations.get(prefix);
    }

    public String findPrefix(String namespaceURI) {
        String prefix;
        if (this.namespaceDeclarations != null && this.namespaceDeclarations.size() != 0 && (prefix = this.getPrefix(namespaceURI)) != null) {
            return prefix;
        }
        if (this.parent != null) {
            return this.parent.findPrefix(namespaceURI);
        }
        return null;
    }

    public String findNamespaceURI(String prefix) {
        String uri;
        if (this.namespaceDeclarations != null && this.namespaceDeclarations.size() != 0 && (uri = this.namespaceDeclarations.get(prefix)) != null) {
            return uri;
        }
        if (this.parent != null) {
            return this.parent.findNamespaceURI(prefix);
        }
        return null;
    }
}

