/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.model;

import java.io.Serializable;
import java.util.Date;
import javax.enterprise.context.RequestScoped;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.User;

@Entity
@RequestScoped
public class Comment
implements Serializable {
    private static final long serialVersionUID = 3429270322123226071L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @OnDelete(action=OnDeleteAction.CASCADE)
    @JoinColumn(nullable=false)
    private Image image;
    @ManyToOne(fetch=FetchType.EAGER)
    @OnDelete(action=OnDeleteAction.CASCADE)
    @JoinColumn(nullable=true)
    private User author;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;
    @NotNull
    @NotEmpty
    @Length(min=2)
    @Column(length=1024, nullable=false)
    private String message;

    public boolean isPreDefined() {
        return this.getImage().isPreDefined();
    }

    public Long getId() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public User getAuthor() {
        return this.author;
    }

    public void setAuthor(User author) {
        this.author = author;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Comment comment = (Comment)obj;
        return (this.id == null ? comment.getId() == null : this.id.equals(comment.getId())) && (this.author == null ? comment.getAuthor() == null : this.author.equals((Object)comment.getAuthor())) && this.image.equals((Object)comment.getImage()) && this.message.equals(comment.getMessage());
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.image.hashCode();
        result = 31 * result + this.author.hashCode();
        result = 31 * result + this.message.hashCode();
        return result;
    }
}

