/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.social;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.manager.Model;
import org.richfaces.photoalbum.model.Event;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.model.event.SimpleEvent;
import org.richfaces.photoalbum.social.facebook.FacebookAlbumCache;
import org.richfaces.photoalbum.social.gplus.GooglePlusAlbumCache;
import org.richfaces.photoalbum.util.ImageHandler;

@Named
@SessionScoped
public class EventAlbumsHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    Model model;
    @Inject
    GooglePlusAlbumCache gpac;
    @Inject
    FacebookAlbumCache fac;
    private String fbAlbumIds;
    private List<String> emptyFacebookIds = new LinkedList();
    private List<String> facebookAlbumIds = new ArrayList();
    private List<String> emptyGoogleIds = new LinkedList();
    private List<String> googleAlbumIds = new ArrayList();
    private List<ImageHandler> images = new ArrayList();
    private boolean pollEnabled;
    private boolean facebookNeedsUpdate;
    private boolean googleNeedsUpdate;

    public void init(@Observes @EventType(value=Events.EVENT_DISPLAYED_EVENT) SimpleEvent se) {
        this.images = new ArrayList();
        this.setFacebookNeedsUpdate(false);
        this.setGoogleNeedsUpdate(false);
        Event event = this.model.getSelectedEvent();
        for (Image i : event.getShelf().getImages()) {
            this.images.add(new ImageHandler((Object)i));
        }
        this.setFacebookNeedsUpdate(this.fac.isLoaded());
        this.emptyGoogleIds = new LinkedList();
        this.googleAlbumIds = new ArrayList();
        this.googleAlbumIds = event.getGooglePlusAlbumIds();
        if (this.googleAlbumIds.size() != 0) {
            for (String fullId : this.googleAlbumIds) {
                if (!this.gpac.isAlbumLoaded(fullId)) {
                    this.emptyGoogleIds.add(fullId);
                    continue;
                }
                for (JSONObject gImage : this.gpac.getImagesOfAlbum(fullId).values()) {
                    this.images.add(new ImageHandler((Object)gImage));
                }
            }
        }
        this.setGoogleNeedsUpdate(this.emptyGoogleIds.size() > 0);
        this.setPollEnabled(this.emptyGoogleIds.size() > 0);
    }

    private void addGoogleImages(String albumId) {
        for (JSONObject jo : this.gpac.getImagesOfAlbum(albumId).values()) {
            this.images.add(new ImageHandler((Object)jo));
        }
    }

    public void loadFBImages() {
        for (String albumId : this.emptyFacebookIds) {
            for (JSONObject jo : this.fac.getImagesFromAlbum(albumId)) {
                this.images.add(new ImageHandler((Object)jo));
            }
        }
    }

    public boolean isEventEmpty() {
        return this.googleAlbumIds.size() == 0;
    }

    public boolean isAllLoaded() {
        return this.emptyGoogleIds.size() == 0 && !this.isEventEmpty();
    }

    public String getNextId() {
        if (this.emptyGoogleIds.size() == 0) {
            return "0";
        }
        return (String)this.emptyGoogleIds.get(0);
    }

    public void loadNext() {
        String currentId = this.getNextId();
        if (!this.gpac.isAlbumLoaded(currentId)) {
            return;
        }
        this.addGoogleImages(currentId);
        this.emptyGoogleIds.remove(this.getNextId());
        this.setPollEnabled(this.emptyGoogleIds.size() != 0);
    }

    public boolean isPollEnabled() {
        return this.pollEnabled;
    }

    public void setPollEnabled(boolean pollEnabled) {
        this.pollEnabled = pollEnabled;
    }

    public List<ImageHandler> getImages() {
        Collections.sort(this.images, new /* Unavailable Anonymous Inner Class!! */);
        return this.images;
    }

    public void setImages(List<ImageHandler> images) {
        this.images = images;
    }

    public boolean isFacebookNeedsUpdate() {
        return this.facebookNeedsUpdate;
    }

    public void setFacebookNeedsUpdate(boolean facebookNeedsUpdate) {
        this.facebookNeedsUpdate = facebookNeedsUpdate;
    }

    public boolean isGoogleNeedsUpdate() {
        return this.googleNeedsUpdate;
    }

    public void setGoogleNeedsUpdate(boolean googleNeedsUpdate) {
        this.googleNeedsUpdate = googleNeedsUpdate;
    }
}

