/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.component.UITree;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.manager.FileManager;
import org.richfaces.photoalbum.manager.Model;
import org.richfaces.photoalbum.manager.NavigationEnum;
import org.richfaces.photoalbum.manager.UserBean;
import org.richfaces.photoalbum.model.Album;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.MetaTag;
import org.richfaces.photoalbum.model.Shelf;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.model.event.AlbumEvent;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.EventTypeQualifier;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.model.event.ImageEvent;
import org.richfaces.photoalbum.model.event.ShelfEvent;
import org.richfaces.photoalbum.model.event.SimpleEvent;
import org.richfaces.photoalbum.social.facebook.FacebookAlbumCache;
import org.richfaces.photoalbum.social.gplus.GooglePlusAlbumCache;
import org.richfaces.photoalbum.util.Preferred;

@Named
@SessionScoped
public class Controller
implements Serializable {
    private static final long serialVersionUID = 5656562187249324512L;
    @Inject
    Model model;
    @Inject
    @Preferred
    private User loggedUser;
    @Inject
    UserBean loggedUserBean;
    @Inject
    FileManager fileManager;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    @Inject
    @Any
    Event<SimpleEvent> event;
    @Inject
    FacebookAlbumCache fac;
    @Inject
    GooglePlusAlbumCache gpac;
    private int currentPage = 0;

    private User getLoggedUser() {
        return this.loggedUser == null ? this.loggedUserBean.getUser() : this.loggedUser;
    }

    public void selectPublicShelves() {
        this.model.resetModel(NavigationEnum.ANONYM, this.getLoggedUser(), null, null, null, null);
    }

    public void selectShelves() {
        this.model.resetModel(NavigationEnum.ALL_SHELFS, this.getLoggedUser(), null, null, null, null);
    }

    public void selectAlbums() {
        this.model.resetModel(NavigationEnum.ALL_ALBUMS, this.getLoggedUser(), null, null, null, null);
    }

    public void selectImages() {
        this.model.resetModel(NavigationEnum.ALL_IMAGES, this.getLoggedUser(), null, null, null, this.getLoggedUser().getImages());
    }

    public void startEditShelf(Shelf shelf) {
        if (this.getLoggedUser() == null) {
            return;
        }
        if (!this.canViewShelf(shelf)) {
            this.showError("", "You have no rights to view this album");
            return;
        }
        this.model.resetModel(NavigationEnum.SHELF_EDIT, shelf.getOwner(), shelf, null, null, null);
    }

    public void cancelEditShelf() {
        this.model.resetModel(NavigationEnum.SHELF_PREVIEW, this.model.getSelectedShelf().getOwner(), this.model.getSelectedShelf(), null, null, null);
    }

    public void showAlbum(Album album) {
        if (!this.canViewAlbum(album)) {
            this.showError("", "You have no rights to view this album");
            return;
        }
        if (!this.fileManager.isDirectoryPresent(album.getPath())) {
            this.showError("", "This album has been recently deleted. Please, refresh your browser to see actual data.");
            this.model.resetModel(NavigationEnum.SHELF_PREVIEW, album.getOwner(), album.getShelf(), null, null, null);
            return;
        }
        this.setPage(Integer.valueOf(0));
        this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, album.getOwner(), album.getShelf(), album, null, album.getImages());
    }

    public void showFBAlbum(String albumId) {
        this.fac.setCurrentAlbumId(albumId);
        this.model.resetModel(NavigationEnum.FB_ALBUM_PREVIEW, this.getLoggedUser(), null, null, null, null);
    }

    public void showFbImage(String imageId) {
        this.setFPage(Integer.valueOf(0));
        this.fac.setCurrentImageId(imageId);
        this.model.resetModel(NavigationEnum.FB_IMAGE_PREVIEW, this.getLoggedUser(), null, null, null, null);
    }

    public void showFbShelf() {
        this.model.resetModel(NavigationEnum.FB_SHELF, this.getLoggedUser(), null, null, null, null);
    }

    public void showGPlusShelf() {
        this.model.resetModel(NavigationEnum.GPLUS_SHELF, this.getLoggedUser(), null, null, null, null);
    }

    public void showGPlusAlbum() {
        this.model.resetModel(NavigationEnum.GPLUS_ALBUM_PREVIEW, this.getLoggedUser(), null, null, null, null);
    }

    public void showGPlusImage(String imageId) {
        this.setGplusPage(Integer.valueOf(0));
        this.gpac.setCurrentImageId(imageId);
        this.model.resetModel(NavigationEnum.GPLUS_IMAGE_PREVIEW, this.getLoggedUser(), null, null, null, null);
    }

    public void resetFileUpload() {
        this.pushEvent(Events.CLEAR_FILE_UPLOAD_EVENT);
    }

    public void showImage(Image image) {
        this.pushEvent(Events.CLEAR_EDITOR_EVENT);
        if (!this.canViewImage(image)) {
            this.showError("", "You have no rights to view this album");
            return;
        }
        if (!this.fileManager.isFilePresent(image.getFullPath())) {
            this.showError("", "This image has been recently deleted. Please, refresh your browser to see actual data.");
            this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, image.getAlbum().getOwner(), image.getAlbum().getShelf(), image.getAlbum(), null, image.getAlbum().getImages());
            return;
        }
        this.model.resetModel(NavigationEnum.ALBUM_IMAGE_PREVIEW, image.getAlbum().getOwner(), image.getAlbum().getShelf(), image.getAlbum(), image, image.getAlbum().getImages());
        image.setVisited(true);
    }

    public void showNextImage() {
        int max;
        int id = this.model.getSelectedAlbum().getImages().indexOf(this.model.getSelectedImage());
        if (id == (max = this.model.getSelectedAlbum().getImages().size() - 1)) {
            id = -1;
        }
        this.setPage(Integer.valueOf((id + 1) / 5 + 1));
        this.showImage((Image)this.model.getSelectedAlbum().getImages().get(id + 1));
    }

    public void showPrevImage() {
        int id = this.model.getSelectedAlbum().getImages().indexOf(this.model.getSelectedImage());
        int max = this.model.getSelectedAlbum().getImages().size() - 1;
        if (id == 0) {
            id = max + 1;
        }
        this.setPage(Integer.valueOf((id - 1) / 5 + 1));
        this.showImage((Image)this.model.getSelectedAlbum().getImages().get(id - 1));
    }

    public void showNextFbImage() {
        int max;
        int id = this.fac.getCurrentImages().indexOf(this.fac.getCurrentImage());
        if (id == (max = this.fac.getCurrentImages().size() - 1)) {
            id = -1;
        }
        this.setPage(Integer.valueOf((id + 1) / 5 + 1));
        this.showFbImage(((JSONObject)this.fac.getCurrentImages().get(id + 1)).optString("id"));
    }

    public void showPrevFbImage() {
        int id = this.fac.getCurrentImages().indexOf(this.fac.getCurrentImage());
        int max = this.fac.getCurrentImages().size() - 1;
        if (id == 0) {
            id = max + 1;
        }
        this.setPage(Integer.valueOf((id - 1) / 5 + 1));
        this.showFbImage(((JSONObject)this.fac.getCurrentImages().get(id - 1)).optString("id"));
    }

    public void showNextGPlusImage() {
        int max;
        int id = this.gpac.getCurrentImages().indexOf(this.gpac.getCurrentImage());
        if (id == (max = this.gpac.getCurrentImages().size() - 1)) {
            id = -1;
        }
        this.setPage(Integer.valueOf((id + 1) / 5 + 1));
        this.showGPlusImage(((JSONObject)this.gpac.getCurrentImages().get(id + 1)).optString("id"));
    }

    public void showPrevGPlusImage() {
        int id = this.gpac.getCurrentImages().indexOf(this.gpac.getCurrentImage());
        int max = this.gpac.getCurrentImages().size() - 1;
        if (id == 0) {
            id = max + 1;
        }
        this.setPage(Integer.valueOf((id - 1) / 5 + 1));
        this.showGPlusImage(((JSONObject)this.gpac.getCurrentImages().get(id - 1)).optString("id"));
    }

    public void startEditImage(Image image) {
        if (this.getLoggedUser() == null) {
            return;
        }
        if (!this.canViewImage(image)) {
            this.showError("", "You have no rights to view this album");
            return;
        }
        this.model.resetModel(NavigationEnum.ALBUM_IMAGE_EDIT, image.getOwner(), image.getAlbum().getShelf(), image.getAlbum(), image, image.getAlbum().getImages());
    }

    public void editUser() {
        if (this.getLoggedUser() == null) {
            return;
        }
        this.pushEvent(Events.EDIT_USER_EVENT);
    }

    public void cancelEditUser() {
        this.pushEvent(Events.CANCEL_EDIT_USER_EVENT);
    }

    public void cancelEditImage() {
        this.model.resetModel(NavigationEnum.ALBUM_IMAGE_PREVIEW, this.model.getSelectedImage().getAlbum().getShelf().getOwner(), this.model.getSelectedImage().getAlbum().getShelf(), this.model.getSelectedImage().getAlbum(), this.model.getSelectedImage(), this.model.getSelectedImage().getAlbum().getImages());
    }

    public void showShelf(Shelf shelf) {
        if (!this.fileManager.isDirectoryPresent(shelf.getPath())) {
            this.showError("", "This album group has been recently deleted. Please, refresh your browser to see actual data.");
            this.model.resetModel(NavigationEnum.ANONYM, shelf.getOwner(), null, null, null, null);
            return;
        }
        this.model.resetModel(NavigationEnum.SHELF_PREVIEW, shelf.getOwner(), shelf, null, null, null);
    }

    public void showEvent(org.richfaces.photoalbum.model.Event event) {
        this.model.resetModel(NavigationEnum.EVENT_PREVIEW, this.getLoggedUser(), null, null, null, null, event);
        this.pushEvent(Events.EVENT_DISPLAYED_EVENT);
    }

    public void startEditAlbum(Album album) {
        if (this.getLoggedUser() == null) {
            return;
        }
        if (!album.isOwner(this.getLoggedUser())) {
            this.showError("", "You have no rights to view this album");
            return;
        }
        this.model.resetModel(NavigationEnum.ALBUM_EDIT, album.getOwner(), album.getShelf(), album, null, album.getImages());
    }

    public void cancelEditAlbum() {
        this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, this.model.getSelectedAlbum().getOwner(), this.model.getSelectedAlbum().getShelf(), this.model.getSelectedAlbum(), null, this.model.getSelectedAlbum().getImages());
    }

    public void onAlbumAdded(@Observes @EventType(value=Events.ALBUM_ADDED_EVENT) AlbumEvent ae) {
        Album album = ae.getAlbum();
        if (album.isShowAfterCreate()) {
            this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, album.getOwner(), album.getShelf(), album, null, album.getImages());
        }
    }

    public void onAlbumEdited(@Observes @EventType(value=Events.ALBUM_EDITED_EVENT) AlbumEvent ae) {
        Album album = ae.getAlbum();
        this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, this.model.getSelectedUser(), this.model.getSelectedShelf(), album, null, album.getImages());
    }

    public void onAlbumDeleted(@Observes @EventType(value=Events.ALBUM_DELETED_EVENT) AlbumEvent ae) {
        this.loggedUserBean.refreshUser();
        this.model.resetModel(NavigationEnum.ALL_ALBUMS, this.getLoggedUser(), ae.getAlbum().getShelf(), null, null, null);
    }

    public void onShelfDeleted(@Observes @EventType(value=Events.SHELF_DELETED_EVENT) ShelfEvent se) {
        this.loggedUserBean.refreshUser();
        this.model.resetModel(NavigationEnum.ALL_SHELFS, this.getLoggedUser(), null, null, null, null);
    }

    public void onShelfAdded(@Observes @EventType(value=Events.SHELF_ADDED_EVENT) ShelfEvent se) {
        Shelf shelf = se.getShelf();
        this.model.resetModel(NavigationEnum.SHELF_PREVIEW, shelf.getOwner(), shelf, null, null, null);
    }

    public void onShelfEdited(@Observes @EventType(value=Events.SHELF_EDITED_EVENT) ShelfEvent se) {
        Shelf shelf = se.getShelf();
        this.model.resetModel(NavigationEnum.SHELF_PREVIEW, shelf.getOwner(), shelf, null, null, null);
    }

    public void onEventDeleted(@Observes @EventType(value=Events.EVENT_DELETED_EVENT) ShelfEvent se) {
        this.model.resetModel(NavigationEnum.ANONYM, this.getLoggedUser(), null, null, null, null, null);
    }

    public void onEventAdded(@Observes @EventType(value=Events.EVENT_ADDED_EVENT) ShelfEvent se) {
        this.model.resetModel(NavigationEnum.EVENT_PREVIEW, this.getLoggedUser(), null, null, null, null, se.getEvent());
        this.pushEvent(Events.EVENT_DISPLAYED_EVENT);
    }

    public void onEventEdited(@Observes @EventType(value=Events.EVENT_EDITED_EVENT) ShelfEvent se) {
        this.model.resetModel(NavigationEnum.EVENT_PREVIEW, this.getLoggedUser(), null, null, null, null, se.getEvent());
        this.pushEvent(Events.EVENT_DISPLAYED_EVENT);
    }

    public void onImageDeleted(@Observes @EventType(value=Events.IMAGE_DELETED_EVENT) ImageEvent ie) {
        this.loggedUserBean.refreshUser();
        Album album = ie.getImage().getAlbum();
        this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, this.getLoggedUser(), album.getShelf(), album, null, album.getImages());
    }

    public void onAuthenticate(@Observes @EventType(value=Events.AUTHENTICATED_EVENT) SimpleEvent se) {
        this.model.resetModel(NavigationEnum.ALL_SHELFS, this.getLoggedUser(), null, null, null, null);
    }

    public void showFileUpload() {
        if (this.getLoggedUser().getShelves().size() <= 0) {
            this.showError("", "You must create at least one album group before uploading images!");
            return;
        }
        Album alb = null;
        alb = this.setDefaultAlbumToUpload(alb);
        this.model.resetModel(NavigationEnum.FILE_UPLOAD, this.getLoggedUser(), alb != null ? alb.getShelf() : null, alb, null, alb != null ? alb.getImages() : null);
    }

    public void showFileUpload(Album album) {
        if (!this.isUserAlbum(album)) {
            this.showError("", "You can't add images to this album");
            return;
        }
        this.model.resetModel(NavigationEnum.FILE_UPLOAD, album.getShelf().getOwner(), album.getShelf(), album, null, album.getImages());
    }

    public void showSharedAlbums(User user) {
        this.model.resetModel(NavigationEnum.USER_SHARED_ALBUMS, user, null, null, null, user.getSharedImages());
    }

    public void showSharedImages(User user) {
        this.model.resetModel(NavigationEnum.USER_SHARED_IMAGES, user, null, null, null, user.getSharedImages());
    }

    public void showUser(User user) {
        this.model.resetModel(NavigationEnum.USER_PREFS, user, null, null, null, null);
    }

    public void showCurrentUser() {
        this.showUser(this.getLoggedUser());
    }

    public void showUnvisitedImages(Shelf shelf) {
        this.model.resetModel(NavigationEnum.SHELF_UNVISITED, shelf.getOwner(), shelf, null, null, shelf.getUnvisitedImages());
    }

    public void showUnvisitedImages(Album album) {
        this.model.resetModel(NavigationEnum.ALBUM_UNVISITED, album.getOwner(), album.getShelf(), album, null, album.getUnvisitedImages());
    }

    public void showTag(MetaTag metatag) {
        this.model.resetModel(NavigationEnum.TAGS, this.model.getSelectedUser(), this.model.getSelectedShelf(), this.model.getSelectedAlbum(), this.model.getSelectedImage(), metatag.getImages());
        this.model.setSelectedTag(metatag);
    }

    public void startRegistration(@Observes @EventType(value=Events.START_REGISTER_EVENT) SimpleEvent se) {
        this.model.resetModel(NavigationEnum.REGISTER, this.getLoggedUser(), null, null, null, null);
    }

    public void cancelRegistration() {
        this.model.resetModel(NavigationEnum.ANONYM, this.getLoggedUser(), null, null, null, null);
    }

    public Boolean adviseNodeSelected(UITree tree) {
        Object currentNode = tree.getRowData();
        if (currentNode.equals(this.model.getSelectedAlbum()) || currentNode.equals(this.model.getSelectedShelf())) {
            return true;
        }
        return false;
    }

    public Integer getPage() {
        if (this.currentPage == 0) {
            Integer index = this.model.getSelectedAlbum().getIndex(this.model.getSelectedImage());
            this.currentPage = index / 5 + 1;
        }
        return this.currentPage;
    }

    public void setPage(Integer page) {
        this.currentPage = page;
    }

    public Integer getFPage() {
        if (this.currentPage == 0) {
            Integer index = this.fac.getCurrentImages().indexOf(this.fac.getCurrentImage());
            this.currentPage = index / 5 + 1;
        }
        return this.currentPage;
    }

    public void setFPage(Integer page) {
        this.currentPage = page;
    }

    public Integer getGplusPage() {
        if (this.currentPage == 0) {
            Integer index = this.gpac.getCurrentImages().indexOf(this.gpac.getCurrentImage());
            this.currentPage = index / 5 + 1;
        }
        return this.currentPage;
    }

    public void setGplusPage(Integer page) {
        this.currentPage = page;
    }

    public boolean isUserImage(Image image) {
        if (image == null || image.getOwner() == null || this.getLoggedUser() == null) {
            return false;
        }
        return this.getLoggedUser().equals((Object)image.getOwner());
    }

    public boolean isUserHaveShelves() {
        return this.getLoggedUser().getShelves().size() > 0;
    }

    public boolean isUserHaveAlbums() {
        return this.getLoggedUser().getAlbums().size() > 0;
    }

    public boolean isUserShelf(Shelf shelf) {
        return shelf != null && this.getLoggedUser() != null && this.getLoggedUser().equals((Object)shelf.getOwner());
    }

    public boolean isUserAlbum(Album album) {
        return album != null && this.getLoggedUser() != null && this.getLoggedUser().equals((Object)album.getOwner());
    }

    public boolean isProfileEditable(User selectedUser) {
        return selectedUser != null && selectedUser.equals((Object)this.getLoggedUser());
    }

    private boolean canViewShelf(Shelf shelf) {
        return shelf != null && shelf.isOwner(this.getLoggedUser()) || shelf.isShared();
    }

    private boolean canViewAlbum(Album album) {
        return album != null && album.getShelf() != null && (album.getShelf().isShared() || album.isOwner(this.getLoggedUser()));
    }

    private boolean canViewImage(Image image) {
        return image != null && image.getAlbum() != null && image.getAlbum().getShelf() != null && (image.getAlbum().getShelf().isShared() || image.isOwner(this.getLoggedUser()));
    }

    public void showError(String summary, String errorMessage) {
        this.error.fire((Object)new ErrorEvent(summary, errorMessage));
    }

    private void pushEvent(Events eventType) {
        this.event.select(new Annotation[]{new EventTypeQualifier(eventType)}).fire((Object)new SimpleEvent());
    }

    private Album setDefaultAlbumToUpload(Album alb) {
        if (this.isUserAlbum(this.model.getSelectedAlbum())) {
            alb = this.model.getSelectedAlbum();
        }
        if (alb == null && this.getLoggedUser() != null && this.getLoggedUser().getShelves().size() > 0 && ((Shelf)this.getLoggedUser().getShelves().get(0)).getAlbums().size() > 0) {
            for (Shelf s : this.getLoggedUser().getShelves()) {
                if (s.getAlbums().size() <= 0) continue;
                alb = (Album)s.getAlbums().get(0);
                break;
            }
        }
        return alb;
    }

    public boolean isEventFacebookAlbum(String id) {
        return this.model.getSelectedEvent() != null && this.model.getSelectedEvent().getFacebookAlbumIds().contains(id);
    }

    public boolean isEventGoogleAlbum(String id) {
        return this.model.getSelectedEvent() != null && this.model.getSelectedEvent().getGooglePlusAlbumIds().contains(id);
    }
}

