/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import com.google.common.io.Files;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.photoalbum.manager.UserBean;
import org.richfaces.photoalbum.model.Album;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.model.event.AlbumEvent;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.model.event.ImageEvent;
import org.richfaces.photoalbum.model.event.ShelfEvent;
import org.richfaces.photoalbum.model.event.SimpleEvent;
import org.richfaces.photoalbum.util.FileHandler;
import org.richfaces.photoalbum.util.FileManipulation;
import org.richfaces.photoalbum.util.ImageDimension;

@Named
@ApplicationScoped
public class FileManager {
    @Inject
    private File uploadRoot;
    @Inject
    private String uploadRootPath;
    @Inject
    UserBean userBean;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;

    public File getFileByPath(String path) {
        if (this.uploadRoot != null) {
            File result = new File(this.uploadRoot, path);
            try {
                String resultCanonicalPath = result.getCanonicalPath();
                if (!resultCanonicalPath.startsWith(this.uploadRootPath)) {
                    result = null;
                }
                return result;
            }
            catch (IOException e) {
                this.error.fire((Object)new ErrorEvent("no file found"));
                result = null;
                return result;
            }
        }
        return null;
    }

    public void onAlbumDeleted(@Observes @EventType(value=Events.ALBUM_DELETED_EVENT) AlbumEvent ae) {
        if (!this.userBean.isLoggedIn()) {
            return;
        }
        this.deleteDirectory(ae.getPath());
    }

    public void onShelfDeleted(@Observes @EventType(value=Events.SHELF_DELETED_EVENT) ShelfEvent se) {
        if (!this.userBean.isLoggedIn()) {
            return;
        }
        this.deleteDirectory(se.getPath());
    }

    public void onUserDeleted(@Observes @EventType(value=Events.USER_DELETED_EVENT) SimpleEvent se) {
        this.deleteDirectory(this.userBean.getUser().getPath());
    }

    public void onShelfAdded(@Observes @EventType(value=Events.SHELF_ADDED_EVENT) ShelfEvent se) {
        File directory = this.getFileByPath(se.getShelf().getPath());
        FileManipulation.addDirectory((File)directory);
    }

    public void onAlbumAdded(@Observes @EventType(value=Events.ALBUM_ADDED_EVENT) AlbumEvent ae) {
        File directory = this.getFileByPath(ae.getAlbum().getPath());
        FileManipulation.addDirectory((File)directory);
    }

    public boolean saveAvatar(File avatarData, User user) {
        String avatarPath = File.separator + user.getLogin() + File.separator + "avatar.jpg";
        this.createDirectoryIfNotExist(avatarPath);
        try {
            FileInputStream is = new FileInputStream(avatarData);
            return this.writeFile(avatarPath, (InputStream)is, "", 80, true);
        }
        catch (IOException ioe) {
            this.error.fire((Object)new ErrorEvent("error saving avatar"));
            return false;
        }
    }

    public void deleteImage(@Observes @EventType(value=Events.IMAGE_DELETED_EVENT) ImageEvent ie) {
        if (!this.userBean.isLoggedIn()) {
            return;
        }
        for (ImageDimension d : ImageDimension.values()) {
            FileManipulation.deleteFile((File)this.getFileByPath(this.transformPath(ie.getPath(), d.getFilePostfix())));
        }
    }

    public boolean addImage(String fileName, FileHandler fileHandler) throws IOException {
        if (!this.userBean.isLoggedIn()) {
            return false;
        }
        this.createDirectoryIfNotExist(fileName);
        for (ImageDimension d : ImageDimension.values()) {
            try {
                InputStream in = fileHandler.getInputStream();
                if (!this.writeFile(fileName, in, d.getFilePostfix(), d.getX(), true)) {
                    return false;
                }
                in.close();
            }
            catch (IOException ioe) {
                this.error.fire((Object)new ErrorEvent("Error", "error saving image: " + ioe.getMessage()));
                return false;
            }
        }
        return true;
    }

    public String transformPath(String target, String substitute) {
        if (target.length() < 2 || target.lastIndexOf(".") == -1) {
            return "";
        }
        String begin = target.substring(0, target.lastIndexOf("."));
        String end = target.substring(target.lastIndexOf("."));
        return begin + substitute + end;
    }

    public File getFileByAbsolutePath(String path) {
        return new File(path);
    }

    public boolean isDirectoryPresent(String path) {
        File file = this.getFileByPath(path);
        return file.exists() && file.isDirectory();
    }

    public boolean isFilePresent(String path) {
        File file = this.getFileByPath(path);
        return file.exists();
    }

    public void renameAlbumDirectory(@Observes @EventType(value=Events.ALBUM_DRAGGED_EVENT) AlbumEvent ae) {
        String pathOld = ae.getPath();
        Album album = ae.getAlbum();
        File file = this.getFileByPath(pathOld);
        File file2 = this.getFileByPath(album.getPath());
        if (file2.exists()) {
            if (file2.isDirectory()) {
                FileManipulation.deleteDirectory((File)file2, (boolean)false);
            } else {
                FileManipulation.deleteFile((File)file2);
            }
        }
        try {
            Files.createParentDirs((File)file2);
        }
        catch (IOException ioe) {
            this.error.fire((Object)new ErrorEvent("Error moving file", ioe.getMessage()));
        }
        file.renameTo(file2);
    }

    public void renameImageFile(@Observes @EventType(value=Events.IMAGE_DRAGGED_EVENT) ImageEvent ie) {
        File file = null;
        File file2 = null;
        String pathOld = ie.getPath();
        Image image = ie.getImage();
        for (ImageDimension dimension : ImageDimension.values()) {
            file = this.getFileByPath(this.transformPath(pathOld, dimension.getFilePostfix()));
            file2 = this.getFileByPath(this.transformPath(image.getFullPath(), dimension.getFilePostfix()));
            if (file2.exists()) {
                if (file2.isDirectory()) {
                    FileManipulation.deleteDirectory((File)file2, (boolean)false);
                } else {
                    FileManipulation.deleteFile((File)file2);
                }
            }
            file.renameTo(file2);
        }
    }

    private boolean writeFile(String newFileName, InputStream inputStream, String pattern, int size, boolean includeUploadRoot) {
        BufferedImage bsrc = null;
        String format = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(newFileName).split("/")[1];
        try {
            bsrc = FileManipulation.bitmapToImage((InputStream)inputStream, (String)format);
        }
        catch (IOException e1) {
            this.error.fire((Object)new ErrorEvent("Error", "error reading file<br/>" + e1.getMessage()));
            return false;
        }
        int resizedParam = bsrc.getWidth() > bsrc.getHeight() ? bsrc.getWidth() : bsrc.getHeight();
        double scale = (double)size / (double)resizedParam;
        Double widthInDouble = Double.valueOf(scale) * (double)bsrc.getWidth();
        int width = widthInDouble.intValue();
        Double heightInDouble = Double.valueOf(scale) * (double)bsrc.getHeight();
        int height = heightInDouble.intValue();
        if (width > bsrc.getWidth() || height > bsrc.getHeight() || size == 0) {
            width = bsrc.getWidth();
            height = bsrc.getHeight();
        }
        BufferedImage bdest = FileManipulation.getScaledInstance((BufferedImage)bsrc, (int)width, (int)height, (Object)RenderingHints.VALUE_INTERPOLATION_BICUBIC, (boolean)true);
        String dest = includeUploadRoot ? this.uploadRootPath + this.transformPath(newFileName, pattern) : this.transformPath(newFileName, pattern);
        try {
            FileManipulation.imageToBitmap((BufferedImage)bdest, (String)dest, (String)format);
        }
        catch (IOException ex) {
            this.error.fire((Object)new ErrorEvent("Error", "error saving image to disc: " + ex.getMessage()));
            return false;
        }
        return true;
    }

    private void deleteDirectory(String directory) {
        File file = this.getFileByPath(directory);
        FileManipulation.deleteDirectory((File)file, (boolean)false);
    }

    private void createDirectoryIfNotExist(String fileNameNew) {
        String directory;
        File file;
        int lastIndexOf = fileNameNew.lastIndexOf(File.separator);
        if (lastIndexOf > 0 && !(file = this.getFileByPath(directory = fileNameNew.substring(0, lastIndexOf))).exists()) {
            file.mkdirs();
        }
    }
}

