/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.richfaces.photoalbum.manager.NavigationEnum;
import org.richfaces.photoalbum.model.Comment;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.MetaTag;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.model.actions.IImageAction;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.model.event.ImageEvent;
import org.richfaces.photoalbum.model.event.NavEvent;
import org.richfaces.photoalbum.model.event.SimpleEvent;
import org.richfaces.photoalbum.util.Preferred;

@Named
@RequestScoped
public class ImageManager {
    private static final String IMAGE_DIRECT_LINK = "/includes/directImage.seam?imageId=";
    @Inject
    IImageAction imageAction;
    @Inject
    @Preferred
    User user;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    @Inject
    @Any
    Event<SimpleEvent> event;
    @Inject
    @EventType(value=Events.UPDATE_MAIN_AREA_EVENT)
    Event<NavEvent> navEvent;
    @Inject
    @EventType(value=Events.IMAGE_DELETED_EVENT)
    Event<ImageEvent> imageEvent;
    private String message = "";

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void deleteImage(Image image) {
        if (this.user == null) {
            return;
        }
        String pathToDelete = image.getFullPath();
        try {
            this.imageAction.deleteImage(image);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while deleting the image from the database. <br/>" + e.getMessage()));
            return;
        }
        this.imageEvent.fire((Object)new ImageEvent(image, pathToDelete));
    }

    public void editImage(Image image, boolean editFromInplace) {
        if (this.user == null) {
            return;
        }
        try {
            Validator validator;
            Set constraintViolations;
            if (this.user.hasImageWithName(image)) {
                this.error.fire((Object)new ErrorEvent("Error", "You already have an image with the given name in selected album"));
                this.imageAction.resetImage(image);
                return;
            }
            if (editFromInplace && (constraintViolations = (validator = Validation.buildDefaultValidatorFactory().getValidator()).validate((Object)image, new Class[0])).size() > 0) {
                for (ConstraintViolation cv : constraintViolations) {
                    this.error.fire((Object)new ErrorEvent("Constraint violation", cv.getMessage()));
                }
                this.imageAction.resetImage(image);
                return;
            }
            this.imageAction.editImage(image, !editFromInplace);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving the image to the database. <br/>" + e.getMessage()));
            this.imageAction.resetImage(image);
            return;
        }
        this.navEvent.fire((Object)new NavEvent(NavigationEnum.ALBUM_IMAGE_PREVIEW));
    }

    public void addComment(Image image) {
        if (this.user == null) {
            return;
        }
        if (null == this.user.getLogin()) {
            this.error.fire((Object)new ErrorEvent("For adding the comment for this picture you have login"));
            return;
        }
        if (this.message.trim().equals("")) {
            this.error.fire((Object)new ErrorEvent("Comment must not be null"));
            return;
        }
        Comment comment = new Comment();
        comment.setAuthor(this.user);
        comment.setImage(image);
        comment.setDate(new Date());
        comment.setMessage(this.message);
        try {
            this.imageAction.addComment(comment);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving the comment to the database. <br/>" + e.getMessage()));
            return;
        }
        this.message = "";
    }

    public void deleteComment(Comment comment) {
        if (this.user == null) {
            return;
        }
        try {
            this.imageAction.deleteComment(comment);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while deleting the comment from the database. <br/>" + e.getMessage()));
            return;
        }
    }

    public List<MetaTag> popularTags() {
        return this.imageAction.getPopularTags();
    }

    public List<MetaTag> autoComplete(Object suggest) {
        String temp = (String)suggest;
        if (temp == null || temp.trim().equals("")) {
            return null;
        }
        return this.imageAction.getTagsLikeString(temp);
    }

    public String getImageDirectLink(Image image) {
        String directLink = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            return null;
        }
        String value = context.getApplication().getViewHandler().getResourceURL(context, IMAGE_DIRECT_LINK + image.getId());
        ExternalContext externalContext = context.getExternalContext();
        String relativeURL = externalContext.encodeResourceURL(value);
        Object request = externalContext.getRequest();
        if (request instanceof HttpServletRequest) {
            directLink = this.createServerURL((HttpServletRequest)request) + relativeURL;
        }
        return directLink;
    }

    private String createServerURL(HttpServletRequest request) {
        StringBuffer url = new StringBuffer();
        if (request != null) {
            String name = request.getServerName();
            String protocol = request.getProtocol().split("/")[0].toLowerCase();
            int port = request.getServerPort();
            url.append(protocol);
            url.append("://");
            url.append(name);
            url.append(":");
            url.append(Integer.toString(port));
        }
        return url.toString();
    }
}

