/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.social.facebook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.Events;

@Named
@ApplicationScoped
public class FacebookAlbumCache {
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    private Map<String, JSONObject> albums = new HashMap();
    private Map<String, Map<String, JSONObject>> images = new HashMap();
    private String currentAlbumId;
    private String currentImageId;
    private boolean loaded = false;
    private boolean emptyCache = true;

    public void setAll(String json) {
        this.albums = new HashMap();
        this.images = new HashMap();
        try {
            JSONArray jAlbums = new JSONArray(json);
            for (int i = 0; i < jAlbums.length(); ++i) {
                JSONObject jo = jAlbums.getJSONObject(i);
                if (!jo.has("id")) {
                    this.error.fire((Object)new ErrorEvent("Error, object does not contain albums"));
                }
                String albumId = jo.getString("id");
                this.images.put(albumId, new HashMap());
                if (jo.getInt("size") > 0) {
                    this.storeImagesToAlbum(albumId, jo.getJSONArray("images"));
                    jo.remove("images");
                }
                this.albums.put(albumId, jo);
            }
            this.loaded = true;
            this.emptyCache = jAlbums.length() == 0;
        }
        catch (JSONException e) {
            this.error.fire((Object)new ErrorEvent("Error: ", e.getMessage()));
        }
    }

    public void storeImagesToAlbum(String albumId, JSONArray ja) {
        String imageId = "";
        Map album = (Map)this.images.get(albumId);
        try {
            for (int i = 0; i < ja.length(); ++i) {
                JSONObject jo = ja.getJSONObject(i);
                if (!jo.has("id")) {
                    this.error.fire((Object)new ErrorEvent("Error, object does not contain images"));
                }
                imageId = jo.getString("id");
                album.put(imageId, jo);
            }
        }
        catch (JSONException je) {
            this.error.fire((Object)new ErrorEvent("Error", je.getMessage()));
        }
    }

    public JSONObject getAlbum(String albumId) {
        return (JSONObject)this.albums.get(albumId);
    }

    public Map<String, JSONObject> getImageMap(String albumId) {
        return (Map)this.images.get(albumId);
    }

    public List<JSONObject> getImagesFromAlbum(String albumId) {
        return new ArrayList<JSONObject>(((Map)this.images.get(albumId)).values());
    }

    public List<JSONObject> getAlbums() {
        return new ArrayList<JSONObject>(this.albums.values());
    }

    public String getCurrentAlbumId() {
        return this.currentAlbumId;
    }

    public void setCurrentAlbumId(String currentAlbumId) {
        this.currentAlbumId = currentAlbumId;
    }

    public String getCurrentImageId() {
        return this.currentImageId;
    }

    public void setCurrentImageId(String currentImageId) {
        this.currentImageId = currentImageId;
    }

    public JSONObject getCurrentAlbum() {
        return (JSONObject)this.albums.get(this.currentAlbumId);
    }

    public List<JSONObject> getCurrentImages() {
        return new ArrayList<JSONObject>(((Map)this.images.get(this.currentAlbumId)).values());
    }

    public JSONObject getCurrentImage() {
        return (JSONObject)((Map)this.images.get(this.currentAlbumId)).get(this.currentImageId);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isEmptyCache() {
        return this.emptyCache;
    }

    public void setEmptyCache(boolean emptyCache) {
        this.emptyCache = emptyCache;
    }
}

