/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ui;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.photoalbum.manager.AlbumManager;
import org.richfaces.photoalbum.manager.ImageManager;
import org.richfaces.photoalbum.manager.ShelfManager;
import org.richfaces.photoalbum.model.Album;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.Shelf;
import org.richfaces.photoalbum.ui.ConfirmationPopupHelper;

@Named
@ApplicationScoped
public class ConfirmationPopupHelper
implements Serializable {
    private static final long serialVersionUID = 2561824019376412988L;
    private String caption;
    private Actions action;
    private Image image;
    private Shelf shelf;
    private Album album;
    @Inject
    AlbumManager albumManager;
    @Inject
    ShelfManager shelfManager;
    @Inject
    ImageManager imageManager;

    public Actions getDeleteShelf() {
        return Actions.DELETE_SHELF;
    }

    public Actions getDeleteAlbum() {
        return Actions.DELETE_ALBUM;
    }

    public Actions getDeleteImage() {
        return Actions.DELETE_IMAGE;
    }

    public void initImagePopup(Actions action, String caption, Image image) {
        this.caption = caption;
        this.action = action;
        this.image = image;
    }

    public void initAlbumData(Actions action, String caption, Album album) {
        this.caption = caption;
        this.action = action;
        this.album = album;
    }

    public void initShelfData(Actions action, String caption, Shelf shelf) {
        this.caption = caption;
        this.action = action;
        this.shelf = shelf;
    }

    private void deleteAlbum() {
        this.albumManager.deleteAlbum(this.album);
    }

    private void deleteImage() {
        this.imageManager.deleteImage(this.image);
    }

    private void deleteShelf() {
        this.shelfManager.deleteShelf(this.shelf);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Actions getaction() {
        return this.action;
    }

    public void setaction(Actions action) {
        this.action = action;
    }

    public void doAction() {
        switch (1.$SwitchMap$org$richfaces$photoalbum$ui$ConfirmationPopupHelper$Actions[this.action.ordinal()]) {
            case 1: {
                this.deleteShelf();
                break;
            }
            case 2: {
                this.deleteAlbum();
                break;
            }
            case 3: {
                this.deleteImage();
            }
        }
    }
}

