/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.event.DropEvent;
import org.richfaces.event.DropListener;
import org.richfaces.photoalbum.manager.FileManager;
import org.richfaces.photoalbum.model.Album;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.Shelf;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.model.actions.IAlbumAction;
import org.richfaces.photoalbum.model.actions.IEventAction;
import org.richfaces.photoalbum.model.event.AlbumEvent;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.model.event.ImageEvent;
import org.richfaces.photoalbum.util.ApplicationUtils;
import org.richfaces.photoalbum.util.PhotoAlbumException;
import org.richfaces.photoalbum.util.Preferred;

@Named(value="dndManager")
public class DnDManager
implements DropListener {
    @Inject
    @Preferred
    User user;
    @Inject
    FileManager fileManager;
    @Inject
    IAlbumAction albumAction;
    @Inject
    IEventAction eventAction;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    @Inject
    @EventType(value=Events.ALBUM_DRAGGED_EVENT)
    Event<AlbumEvent> albumEvent;
    @Inject
    @EventType(value=Events.IMAGE_DRAGGED_EVENT)
    Event<ImageEvent> imageEvent;

    public void processDrop(DropEvent dropEvent) {
        if (this.user == null) {
            return;
        }
        Object dragValue = dropEvent.getDragValue();
        Object dropValue = dropEvent.getDropValue();
        if (dragValue instanceof Image) {
            if (!((Album)dropValue).getOwner().getLogin().equals(this.user.getLogin())) {
                this.error.fire((Object)new ErrorEvent("", "You can't add photos to this album"));
                return;
            }
            this.handleImage((Image)dragValue, (Album)dropValue);
        } else if (dragValue instanceof Album) {
            if (!((Shelf)dropValue).getOwner().getLogin().equals(this.user.getLogin())) {
                this.error.fire((Object)new ErrorEvent("", "You can't add the album to this album group"));
                return;
            }
            this.handleAlbum((Album)dragValue, (Shelf)dropValue);
        }
    }

    private void handleAlbum(Album dragValue, Shelf dropValue) {
        if (dragValue.getShelf().equals((Object)dropValue)) {
            return;
        }
        String pathOld = dragValue.getPath();
        dropValue.addAlbum(dragValue);
        try {
            this.albumAction.editAlbum(dragValue);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error:", "Error in DB.<br/>" + e.getMessage()));
            return;
        }
        this.albumEvent.fire((Object)new AlbumEvent(dragValue, pathOld));
        ApplicationUtils.addToRerender((String)"treeform");
    }

    private void handleImage(Image dragValue, Album dropValue) {
        if (dragValue.getAlbum().equals((Object)dropValue)) {
            return;
        }
        String pathOld = dragValue.getFullPath();
        dropValue.addImage(dragValue);
        try {
            this.albumAction.editAlbum(dropValue);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error:", "Error in DB.<br/>" + e.getMessage()));
            return;
        }
        this.imageEvent.fire((Object)new ImageEvent(dragValue, pathOld));
        ApplicationUtils.addToRerender((String)"treeform");
    }

    public void addAlbumToEvent(DropEvent dropEvent) {
        if (this.user == null) {
            return;
        }
        Object dragValue = dropEvent.getDragValue();
        org.richfaces.photoalbum.model.Event event = (org.richfaces.photoalbum.model.Event)dropEvent.getDropValue();
        if (dragValue instanceof Album) {
            Album album = (Album)dragValue;
            String pathOld = album.getPath();
            event.getShelf().addAlbum(album);
            try {
                this.albumAction.editAlbum(album);
                this.eventAction.editEvent(event);
            }
            catch (PhotoAlbumException e) {
                this.error.fire((Object)new ErrorEvent("Error:", "Error in DB.: " + e.getMessage()));
            }
            this.albumEvent.fire((Object)new AlbumEvent(album, pathOld));
        }
    }
}

