/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.photoalbum.model.EventCategory;
import org.richfaces.photoalbum.model.Shelf;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.model.actions.IEventAction;
import org.richfaces.photoalbum.model.actions.IShelfAction;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.EventTypeQualifier;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.model.event.ShelfEvent;
import org.richfaces.photoalbum.util.Preferred;

@Named
@RequestScoped
public class EventManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean validationSuccess = false;
    @Inject
    IEventAction eventAction;
    @Inject
    IShelfAction shelfAction;
    @Inject
    @Preferred
    User user;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    @Inject
    @Any
    Event<ShelfEvent> shelfEvent;
    private org.richfaces.photoalbum.model.Event newEvent = new org.richfaces.photoalbum.model.Event();
    private Shelf newShelf = new Shelf();
    private long ecId;

    public org.richfaces.photoalbum.model.Event getEvent() {
        return this.newEvent;
    }

    public void setEvent(org.richfaces.photoalbum.model.Event event) {
        this.newEvent = event;
    }

    public void createEvent() {
        if (this.user == null) {
            return;
        }
        this.newEvent = new org.richfaces.photoalbum.model.Event();
        this.ecId = 1L;
        this.newShelf = new Shelf();
    }

    public void addEvent() {
        if (this.user == null) {
            return;
        }
        this.validationSuccess = true;
        Logger logger = Logger.getLogger("EventManager");
        try {
            EventCategory ec = this.eventAction.getEventCategoryById(this.ecId);
            this.newEvent.setCategory(ec);
            this.newShelf.setName(this.newEvent.getName());
            this.newShelf.setShared(true);
            this.newShelf.setEvent(this.newEvent);
            this.newEvent.setShelf(this.newShelf);
            this.eventAction.addEvent(this.newEvent);
            this.shelfAction.addShelf(this.newShelf);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving the event to the database <br /> " + e.getMessage()));
            logger.log(Level.SEVERE, "exception occured", e);
            return;
        }
        this.shelfEvent.select(new Annotation[]{new EventTypeQualifier(Events.EVENT_ADDED_EVENT)}).fire((Object)new ShelfEvent(this.newEvent));
    }

    public void editEvent(org.richfaces.photoalbum.model.Event event, boolean editFromInplace) {
        if (this.user == null) {
            return;
        }
        try {
            this.eventAction.editEvent(event);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while saving the event to the database <br /> " + e.getMessage()));
            this.eventAction.resetEvent(event);
            return;
        }
        this.shelfEvent.select(new Annotation[]{new EventTypeQualifier(Events.EVENT_EDITED_EVENT)}).fire((Object)new ShelfEvent(event));
    }

    public void deleteEvent(org.richfaces.photoalbum.model.Event event) {
        if (this.user == null) {
            return;
        }
        try {
            this.eventAction.deleteEvent(event);
        }
        catch (Exception e) {
            this.error.fire((Object)new ErrorEvent("Error", " An error occurred while deleting the event to the database <br /> " + e.getMessage()));
            return;
        }
        this.shelfEvent.select(new Annotation[]{new EventTypeQualifier(Events.EVENT_DELETED_EVENT)}).fire((Object)new ShelfEvent(event));
    }

    public boolean isValidationSuccess() {
        return this.validationSuccess;
    }

    public void setValidationSuccess(boolean validationSuccess) {
        this.validationSuccess = validationSuccess;
    }

    public List<org.richfaces.photoalbum.model.Event> getAllEvents() {
        return this.eventAction.getAllEvents();
    }

    public List<EventCategory> getEventCategories() {
        return this.eventAction.getEventCategories();
    }

    public org.richfaces.photoalbum.model.Event getEventById(long id) {
        return this.eventAction.getEventById(id);
    }

    public EventCategory getEventCategoryById(long id) {
        return this.eventAction.getEventCategoryById(id);
    }

    public List<org.richfaces.photoalbum.model.Event> getEventsByCategory(EventCategory ec) {
        return this.eventAction.getEventsByCategory(ec);
    }

    public long getEcId() {
        return this.ecId;
    }

    public void setEcId(long ecId) {
        this.ecId = ecId;
    }
}

