/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.json.JSONObject;
import org.richfaces.photoalbum.manager.FileManager;
import org.richfaces.photoalbum.manager.Model;
import org.richfaces.photoalbum.manager.NavigationEnum;
import org.richfaces.photoalbum.model.Image;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.model.event.SimpleEvent;
import org.richfaces.photoalbum.social.facebook.FacebookAlbumCache;
import org.richfaces.photoalbum.social.gplus.GooglePlusAlbumCache;
import org.richfaces.photoalbum.util.ApplicationUtils;
import org.richfaces.photoalbum.util.ImageHandler;

@ApplicationScoped
@Named(value="slideshow")
public class SlideshowManager
implements Serializable {
    private static final long serialVersionUID = 7801877176558409702L;
    private Integer slideshowIndex;
    private Integer startSlideshowIndex;
    private ImageHandler selectedImage;
    private boolean active;
    private boolean errorDetected;
    @Inject
    Model model;
    @Inject
    FileManager fileManager;
    @Inject
    GooglePlusAlbumCache gpac;
    @Inject
    FacebookAlbumCache fac;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> error;
    private int interval = 4000;

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void startSlideshow() {
        if (!this.active) {
            this.initSlideshow();
        }
        if (this.selectedImage == null && (this.model.getImages() == null || this.model.getImages().size() < 1)) {
            this.onError(true);
            return;
        }
        if (this.selectedImage == null) {
            this.selectedImage = new ImageHandler(this.model.getImages().get(this.slideshowIndex));
        }
        if (this.selectedImage.getType() == 1) {
            ((Image)this.selectedImage.getImage()).setVisited(true);
        }
        this.checkIsFileRecentlyDeleted();
    }

    public void startSlideshow(Image selectedImage) {
        this.initSlideshow();
        this.startSlideshowIndex = this.slideshowIndex = Integer.valueOf(this.model.getImages().indexOf(selectedImage));
        this.selectedImage = new ImageHandler((Object)selectedImage);
        this.startSlideshow();
    }

    public void startSlideshow(JSONObject remoteImage) {
        this.initSlideshow();
        this.selectedImage = new ImageHandler((Object)remoteImage);
        switch (this.selectedImage.getType()) {
            case 2: {
                this.slideshowIndex = this.fac.getCurrentImages().indexOf(remoteImage);
                break;
            }
            case 3: {
                this.slideshowIndex = this.gpac.getCurrentImages().indexOf(remoteImage);
            }
        }
        this.startSlideshowIndex = this.slideshowIndex;
        this.startSlideshow();
    }

    public void startSlideshowRemote(int kind) {
        this.slideshowIndex = this.startSlideshowIndex = Integer.valueOf(0);
        switch (kind) {
            case 2: {
                this.selectedImage = new ImageHandler(this.fac.getCurrentImages().get(0));
                break;
            }
            case 3: {
                this.selectedImage = new ImageHandler(this.gpac.getCurrentImages().get(0));
            }
        }
        this.startSlideshow();
    }

    public void stopSlideshow(@Observes @EventType(value=Events.STOP_SLIDESHOW_EVENT) SimpleEvent se) {
        this.active = false;
        this.errorDetected = false;
        this.selectedImage = null;
        this.slideshowIndex = 0;
        this.startSlideshowIndex = 0;
    }

    public void stopSlideshow() {
        this.stopSlideshow(new SimpleEvent());
    }

    public Integer getSlideshowIndex() {
        return this.slideshowIndex;
    }

    public void setSlideshowIndex(Integer slideshowIndex) {
        this.slideshowIndex = slideshowIndex;
    }

    public ImageHandler getSelectedImage() {
        return this.selectedImage;
    }

    public void setSelectedImage(Image selectedImage) {
        this.selectedImage.setImage((Object)selectedImage);
    }

    public void showNextImage() {
        if (!this.active) {
            this.onError(false);
            return;
        }
        if (this.isLastImage()) {
            this.slideshowIndex = -1;
        }
        Integer n = this.slideshowIndex;
        Integer n2 = this.slideshowIndex = Integer.valueOf(this.slideshowIndex + 1);
        if (this.slideshowIndex == this.startSlideshowIndex) {
            this.onError(false);
            return;
        }
        this.setNextImage();
        this.checkIsFileRecentlyDeleted();
    }

    private boolean isLastImage() {
        switch (this.selectedImage.getType()) {
            case 1: {
                return this.slideshowIndex == this.model.getImages().size() - 1;
            }
            case 2: {
                return this.slideshowIndex == this.fac.getCurrentImages().size() - 1;
            }
            case 3: {
                return this.slideshowIndex == this.gpac.getCurrentImages().size() - 1;
            }
        }
        return true;
    }

    private void setNextImage() {
        switch (this.selectedImage.getType()) {
            case 1: {
                this.selectedImage.setImage(this.model.getImages().get(this.slideshowIndex));
                ((Image)this.selectedImage.getImage()).setVisited(true);
                break;
            }
            case 2: {
                this.selectedImage.setImage(this.fac.getCurrentImages().get(this.slideshowIndex));
                break;
            }
            case 3: {
                this.selectedImage.setImage(this.gpac.getCurrentImages().get(this.slideshowIndex));
            }
        }
    }

    public Integer getStartSlideshowIndex() {
        return this.startSlideshowIndex;
    }

    public void setStartSlideshowIndex(Integer startSlideshowIndex) {
        this.startSlideshowIndex = startSlideshowIndex;
    }

    public boolean isErrorDetected() {
        return this.errorDetected;
    }

    public void setErrorDetected(boolean errorDetected) {
        this.errorDetected = errorDetected;
    }

    private void initSlideshow() {
        this.active = true;
        this.errorDetected = false;
        this.slideshowIndex = 0;
        this.startSlideshowIndex = 0;
    }

    private void onError(boolean isShowOnUI) {
        this.stopSlideshow();
        this.errorDetected = true;
        ApplicationUtils.addToRerender((String)"overForm:mainArea");
        if (isShowOnUI) {
            this.error.fire((Object)new ErrorEvent("No images for slideshow!"));
        }
    }

    private void checkIsFileRecentlyDeleted() {
        if (!this.selectedImage.isLocalImage()) {
            return;
        }
        Image image = (Image)this.selectedImage.getImage();
        if (!this.fileManager.isFilePresent(image.getFullPath())) {
            this.error.fire((Object)new ErrorEvent("This image has been recently deleted. Please, refresh your browser to see actual data."));
            this.active = false;
            this.errorDetected = true;
            ApplicationUtils.addToRerender((String)"overForm:mainArea");
            this.model.resetModel(NavigationEnum.ALBUM_IMAGE_PREVIEW, image.getAlbum().getOwner(), image.getAlbum().getShelf(), image.getAlbum(), null, image.getAlbum().getImages());
            return;
        }
    }
}

