/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.manager.UserManager;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.model.event.ErrorEvent;
import org.richfaces.photoalbum.model.event.EventType;
import org.richfaces.photoalbum.model.event.Events;
import org.richfaces.photoalbum.social.facebook.FacebookBean;
import org.richfaces.photoalbum.social.gplus.GooglePlusBean;
import org.richfaces.photoalbum.util.Preferred;

@Named
@SessionScoped
public class UserBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    EntityManager em;
    @Inject
    UserManager um;
    private User user;
    private String username;
    private String fbPhotoUrl;
    @Inject
    FacebookBean fbBean;
    @Inject
    GooglePlusBean gPlusBean;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<ErrorEvent> event;
    private String password;
    private boolean logged = false;
    private boolean loggedInFB = false;
    private boolean loggedInGPlus = false;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public User logIn(String username, String passwordHash) throws Exception {
        this.user = (User)this.em.createNamedQuery("user-login").setParameter("username", (Object)username).setParameter("password", (Object)passwordHash).getSingleResult();
        this.logged = this.user != null;
        return this.user;
    }

    public User facebookLogIn(String facebookId) {
        if (!this.logged) {
            List users = this.em.createNamedQuery("user-fb-login").setParameter("fbId", (Object)facebookId).getResultList();
            if (users.isEmpty()) {
                this.logged = false;
                this.loggedInFB = false;
                return null;
            }
            this.user = (User)users.get(0);
        }
        this.logged = true;
        this.loggedInFB = true;
        return this.user;
    }

    public User gPlusLogIn(String gPlusId) {
        if (!this.logged) {
            List users = this.em.createNamedQuery("user-gplus-login").setParameter("gPlusId", (Object)gPlusId).getResultList();
            if (users.isEmpty()) {
                this.logged = false;
                this.loggedInGPlus = false;
                return null;
            }
            this.user = (User)users.get(0);
        }
        this.logged = true;
        this.loggedInGPlus = true;
        return this.user;
    }

    @Produces
    @Preferred
    public User getUser() {
        if (!this.logged) {
            return null;
        }
        return this.user;
    }

    public void refreshUser() {
        if (this.logged) {
            this.user = (User)this.em.find(User.class, (Object)this.user.getId());
            this.logged = this.user != null;
        }
    }

    public boolean isLoggedIn() {
        return this.logged;
    }

    public boolean isLoggedInFB() {
        return this.loggedInFB;
    }

    public boolean isLoggedInGPlus() {
        return this.loggedInGPlus;
    }

    public void logout() {
        this.user = null;
        this.logged = false;
        this.loggedInFB = false;
        this.fbPhotoUrl = "";
        this.loggedInGPlus = false;
    }

    public void reset() {
        this.username = "";
        this.password = "";
    }

    public String getFbPhotoUrl() {
        return this.fbPhotoUrl;
    }

    public void setFbPhotoUrl(String fbPhotoUrl) {
        this.fbPhotoUrl = fbPhotoUrl;
    }

    public String toString() {
        return "UserBean{user=" + this.user + ", logged=" + this.logged + '}';
    }

    public String getFbId() {
        return this.user.getFbId().equals("1") ? this.fbBean.getUserId() : "1";
    }

    public String getGplusId() {
        return this.user.getgPlusId().equals("1") ? this.gPlusBean.getUserId() : "1";
    }
}

