/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.deployment;

import com.google.common.base.Function;
import javax.faces.webapp.FacesServlet;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.facesconfig20.FacesConfigVersionType;
import org.jboss.shrinkwrap.descriptor.api.facesconfig20.WebFacesConfigDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;

public class Deployment {
    private WebArchive archive;
    private WebFacesConfigDescriptor facesConfig;
    private WebAppDescriptor webXml;

    protected Deployment(Class<?> testClass) {
        this.archive = testClass != null ? (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(testClass.getSimpleName() + ".war")) : (WebArchive)ShrinkWrap.create(WebArchive.class);
        this.facesConfig = ((WebFacesConfigDescriptor)Descriptors.create(WebFacesConfigDescriptor.class)).version(FacesConfigVersionType._2_0);
        this.webXml = (WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).version("3.0").addNamespace("xmlns:web", "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd")).getOrCreateWelcomeFileList().welcomeFile(new String[]{"faces/index.xhtml"}).up()).getOrCreateContextParam().paramName("org.richfaces.enableControlSkinning").paramValue("false").up()).getOrCreateContextParam().paramName("javax.faces.PROJECT_STAGE").paramValue("Development").up()).getOrCreateServlet().servletName(FacesServlet.class.getSimpleName()).servletClass(FacesServlet.class.getName()).loadOnStartup(Integer.valueOf(1)).up()).getOrCreateServletMapping().servletName(FacesServlet.class.getSimpleName()).urlPattern(new String[]{"*.jsf"}).up()).getOrCreateServletMapping().servletName(FacesServlet.class.getSimpleName()).urlPattern(new String[]{"/faces/*"}).up();
    }

    public WebArchive archive() {
        return this.archive;
    }

    public WebArchive getFinalArchive() {
        return (WebArchive)((WebArchive)this.archive.addAsWebInfResource((Asset)new StringAsset(this.facesConfig.exportAsString()), "faces-config.xml")).addAsWebInfResource((Asset)new StringAsset(this.webXml.exportAsString()), "web.xml");
    }

    public void facesConfig(Function<WebFacesConfigDescriptor, WebFacesConfigDescriptor> transform) {
        this.facesConfig = (WebFacesConfigDescriptor)transform.apply((Object)this.facesConfig);
    }

    public void webXml(Function<WebAppDescriptor, WebAppDescriptor> transform) {
        this.webXml = (WebAppDescriptor)transform.apply((Object)this.webXml);
    }
}

