/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.wait;

import org.richfaces.wait.Condition;
import org.richfaces.wait.WaitTimeoutException;

public class Wait
implements Cloneable {
    public static final long DEFAULT_INTERVAL = 200L;
    public static final long DEFAULT_TIMEOUT = 10000L;
    private boolean isDelayed = true;
    private long interval = 200L;
    private long timeout = 10000L;
    private Object failure = "Waiting timed out";
    private Object[] failureArgs;

    protected long getInterval() {
        return this.interval;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    protected boolean isDelayed() {
        return this.isDelayed;
    }

    public Wait interval(long interval) {
        if (interval == this.interval) {
            return this;
        }
        Wait copy = this.copy();
        copy.interval = interval;
        return copy;
    }

    public Wait timeout(long timeout) {
        if (timeout == this.timeout) {
            return this;
        }
        Wait copy = this.copy();
        copy.timeout = timeout;
        return copy;
    }

    public Wait failWith(Exception exception) {
        if (exception == null && this.failure == null) {
            return this;
        }
        Wait copy = this.copy();
        copy.failure = exception;
        copy.failureArgs = null;
        return copy;
    }

    public Wait failWith(CharSequence failureMessage, Object ... arguments) {
        Wait copy = this.copy();
        copy.failure = failureMessage;
        copy.failureArgs = arguments;
        return copy;
    }

    public Wait dontFail() {
        return this.failWith(null);
    }

    public Wait noDelay() {
        return this.withDelay(false);
    }

    public Wait withDelay(boolean isDelayed) {
        if (isDelayed == this.isDelayed) {
            return this;
        }
        Wait copy = this.copy();
        copy.isDelayed = isDelayed;
        return copy;
    }

    public void until(Condition condition) {
        long start = System.currentTimeMillis();
        long end = start + this.getTimeout();
        boolean delay = this.isDelayed();
        while (System.currentTimeMillis() < end) {
            if (!delay && condition.isTrue()) {
                return;
            }
            delay = false;
            try {
                Thread.sleep(this.getInterval());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (System.currentTimeMillis() < end || !condition.isTrue()) continue;
            return;
        }
        this.fail();
    }

    protected void fail() {
        if (this.failure != null) {
            throw this.prepareFailure();
        }
    }

    private RuntimeException prepareFailure() {
        if (this.failure instanceof RuntimeException) {
            return (RuntimeException)this.failure;
        }
        if (this.failure instanceof CharSequence) {
            return new WaitTimeoutException((CharSequence)this.failure, this.failureArgs);
        }
        return new WaitTimeoutException((Exception)this.failure);
    }

    private Wait copy() {
        try {
            return (Wait)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

