/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.arquillian.page.source;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLUnit;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.richfaces.arquillian.page.source.IgnoreScriptsContent;
import org.xml.sax.SAXException;

public class SourceChecker {
    @Inject
    private Instance<TestClass> testClass;

    public void checkComponentSource(URL pageName, String xmlunitPage, By pageElementToTest) throws IOException, SAXException {
        HtmlElement htmlElement;
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(pageName);
        String locator = pageElementToTest.toString();
        locator = locator.substring(locator.indexOf(58) + 1).trim();
        if (pageElementToTest instanceof By.ById) {
            htmlElement = page.getElementById(locator);
        } else if (pageElementToTest instanceof By.ByTagName) {
            htmlElement = (HtmlElement)page.getElementsByTagName(locator).get(0);
        } else {
            throw new IllegalArgumentException("Only id and name are supported");
        }
        String pageCode = htmlElement.asXml();
        this.checkXmlStructure(xmlunitPage, pageCode);
    }

    protected void checkXmlStructure(String xmlunitPage, String pageCode) throws SAXException, IOException {
        InputStream expectedPageCode = ((TestClass)this.testClass.get()).getJavaClass().getResourceAsStream(xmlunitPage);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        Diff xmlDiff = new Diff((Reader)new InputStreamReader(expectedPageCode), (Reader)new StringReader(pageCode));
        xmlDiff.overrideDifferenceListener(this.getDifferenceListener());
        if (!xmlDiff.similar()) {
            System.out.println("=== ACTUAL PAGE CODE ===");
            System.out.println(pageCode);
            System.out.println("======== ERROR =========");
            System.out.println(xmlDiff.toString());
            System.out.println("========================");
            Assert.fail((String)("XML was not similar:" + xmlDiff.toString()));
        }
    }

    protected DifferenceListener getDifferenceListener() {
        return new IgnoreScriptsContent();
    }
}

