/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.deployment;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.faces.webapp.FacesServlet;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.facesconfig20.FacesConfigVersionType;
import org.jboss.shrinkwrap.descriptor.api.facesconfig20.WebFacesConfigDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyBuilder;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;

public class Deployment {
    private WebArchive archive;
    private WebFacesConfigDescriptor facesConfig;
    private WebAppDescriptor webXml;
    private Set<String> mavenDependencies = Sets.newHashSet();

    protected Deployment(Class<?> testClass) {
        this.archive = testClass != null ? (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(testClass.getSimpleName() + ".war")) : (WebArchive)ShrinkWrap.create(WebArchive.class);
        this.facesConfig = ((WebFacesConfigDescriptor)Descriptors.create(WebFacesConfigDescriptor.class)).version(FacesConfigVersionType._2_0);
        this.webXml = (WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).version("3.0").addNamespace("xmlns:web", "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd")).getOrCreateWelcomeFileList().welcomeFile(new String[]{"faces/index.xhtml"}).up()).getOrCreateContextParam().paramName("org.richfaces.enableControlSkinning").paramValue("false").up()).getOrCreateContextParam().paramName("javax.faces.PROJECT_STAGE").paramValue("Development").up()).getOrCreateServlet().servletName(FacesServlet.class.getSimpleName()).servletClass(FacesServlet.class.getName()).loadOnStartup(Integer.valueOf(1)).up()).getOrCreateServletMapping().servletName(FacesServlet.class.getSimpleName()).urlPattern(new String[]{"*.jsf"}).up()).getOrCreateServletMapping().servletName(FacesServlet.class.getSimpleName()).urlPattern(new String[]{"/faces/*"}).up();
        this.addMavenDependency("com.google.guava:guava", "net.sourceforge.cssparser:cssparser:0.9.5", "org.w3c.css:sac:1.3");
    }

    public WebArchive archive() {
        return this.archive;
    }

    public WebArchive getFinalArchive() {
        WebArchive finalArchive = (WebArchive)((WebArchive)this.archive.addAsWebInfResource((Asset)new StringAsset(this.facesConfig.exportAsString()), "faces-config.xml")).addAsWebInfResource((Asset)new StringAsset(this.webXml.exportAsString()), "web.xml");
        this.exportMavenDependenciesToArchive(finalArchive);
        return finalArchive;
    }

    public void facesConfig(Function<WebFacesConfigDescriptor, WebFacesConfigDescriptor> transform) {
        this.facesConfig = (WebFacesConfigDescriptor)transform.apply((Object)this.facesConfig);
    }

    public void webXml(Function<WebAppDescriptor, WebAppDescriptor> transform) {
        this.webXml = (WebAppDescriptor)transform.apply((Object)this.webXml);
    }

    private void exportMavenDependenciesToArchive(WebArchive finalArchive) {
        HashSet jarFiles = Sets.newHashSet();
        for (String dependency : this.mavenDependencies) {
            File cacheDir = new File("target/shrinkwrap-resolver-cache/" + dependency);
            if (!cacheDir.exists()) {
                this.resolveMavenDependency(dependency, cacheDir);
            }
            File[] listFiles = cacheDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            jarFiles.addAll(Arrays.asList(listFiles));
        }
        File[] files = jarFiles.toArray(new File[jarFiles.size()]);
        finalArchive.addAsLibraries(files);
    }

    public Deployment addMavenDependency(String ... dependencies) {
        this.mavenDependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    private void resolveMavenDependency(String missingDependency, File dir) {
        Collection dependencies = ((MavenDependencyBuilder)((MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class)).loadEffectivePom("pom.xml").artifact(missingDependency)).resolveAs(JavaArchive.class);
        for (JavaArchive archive : dependencies) {
            dir.mkdirs();
            File outputFile = new File(dir, archive.getName());
            InputStream zipStream = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
            try {
                IOUtils.copy((InputStream)zipStream, (OutputStream)new FileOutputStream(outputFile));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

