/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.epr;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.epr.MutableEndpoint;
import org.apache.ode.bpel.epr.URLEndpoint;
import org.apache.ode.bpel.epr.WSAEndpoint;
import org.apache.ode.bpel.epr.WSDL11Endpoint;
import org.apache.ode.bpel.epr.WSDL20Endpoint;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.w3c.dom.Element;

public class EndpointFactory {
    private static final Log __log = LogFactory.getLog(EndpointFactory.class);
    private static QName WSDL20_ELMT_QNAME = new QName(Namespaces.WSDL_20, "service");
    private static QName WSDL11_ELMT_QNAME = new QName(Namespaces.WSDL_11, "service");
    private static QName WSA_ELMT_QNAME = new QName(Namespaces.WS_ADDRESSING_NS, "EndpointReference");
    private static QName SOAP_ADDR_ELMT_QNAME = new QName(Namespaces.SOAP_NS, "address");
    private static MutableEndpoint[] ENDPOINTS = new MutableEndpoint[]{new URLEndpoint(), new WSAEndpoint(), new WSDL11Endpoint(), new WSDL20Endpoint()};

    public static MutableEndpoint createEndpoint(Element endpointElmt) {
        for (MutableEndpoint endpoint : ENDPOINTS) {
            MutableEndpoint se;
            if (!endpoint.accept(endpointElmt)) continue;
            try {
                se = (MutableEndpoint)endpoint.getClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            se.set(endpointElmt);
            return se;
        }
        __log.warn((Object)("Couldnt create any endpoint for element " + DOMUtils.domToString(endpointElmt)));
        return null;
    }

    public static MutableEndpoint convert(QName targetElmtType, Element sourceEndpoint) {
        MutableEndpoint sourceEpr = EndpointFactory.createEndpoint(sourceEndpoint);
        Map transfoMap = sourceEpr.toMap();
        MutableEndpoint targetEpr = targetElmtType == null ? new URLEndpoint() : (targetElmtType.equals(WSDL20_ELMT_QNAME) ? new WSDL20Endpoint() : (targetElmtType.equals(WSDL11_ELMT_QNAME) ? new WSDL11Endpoint() : (targetElmtType.equals(WSA_ELMT_QNAME) ? new WSAEndpoint() : (targetElmtType.equals(SOAP_ADDR_ELMT_QNAME) ? new URLEndpoint() : new URLEndpoint()))));
        targetEpr.fromMap(transfoMap);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Converted endpoint to type " + targetElmtType));
            __log.debug((Object)("Source endpoint " + DOMUtils.domToString(sourceEndpoint)));
            __log.debug((Object)("Destination endpoint " + DOMUtils.domToString(targetEpr.toXML())));
        }
        return targetEpr;
    }

    public static WSAEndpoint convertToWSA(MutableEndpoint source) {
        if (source == null) {
            return null;
        }
        if (source instanceof WSAEndpoint) {
            return (WSAEndpoint)source;
        }
        return new WSAEndpoint(source.toMap());
    }
}

