/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.dao.bpel.CorrelatorDAO;
import org.apache.ode.dao.bpel.CorrelatorMessageDAO;
import org.apache.ode.dao.bpel.MessageExchangeDAO;
import org.apache.ode.dao.bpel.MessageRouteDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.jpa.bpel.BpelDAO;
import org.apache.ode.dao.jpa.bpel.MessageExchangeDAOImpl;
import org.apache.ode.dao.jpa.bpel.MessageRouteDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessInstanceDAOImpl;

@Entity
@Table(name="BPEL_CORRELATOR")
@NamedQueries(value={@NamedQuery(name="DELETE_CORRELATORS_BY_PROCESS", query="delete from CorrelatorDAOImpl as c where c._process = :process")})
public class CorrelatorDAOImpl
extends BpelDAO
implements CorrelatorDAO {
    private static Log __log = LogFactory.getLog(CorrelatorDAOImpl.class);
    public static final String DELETE_CORRELATORS_BY_PROCESS = "DELETE_CORRELATORS_BY_PROCESS";
    private static final String ROUTE_BY_CKEY_HEADER = "select route from MessageRouteDAOImpl as route where route._correlator._process._processType = :ptype and route._correlator._correlatorKey = :corrkey";
    @Id
    @Column(name="CORRELATOR_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _correlatorId;
    @Basic
    @Column(name="CORRELATOR_KEY")
    private String _correlatorKey;
    @OneToMany(targetEntity=MessageRouteDAOImpl.class, mappedBy="_correlator", fetch=FetchType.EAGER, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Collection<MessageRouteDAOImpl> _routes = new ArrayList<MessageRouteDAOImpl>();
    @OneToMany(targetEntity=MessageExchangeDAOImpl.class, mappedBy="_correlator", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Collection<MessageExchangeDAOImpl> _exchanges = new ArrayList<MessageExchangeDAOImpl>();
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PROC_ID")
    private ProcessDAOImpl _process;

    public CorrelatorDAOImpl() {
    }

    public CorrelatorDAOImpl(String correlatorKey, ProcessDAOImpl process) {
        this._correlatorKey = correlatorKey;
        this._process = process;
    }

    @Override
    public void addRoute(String routeGroupId, ProcessInstanceDAO target, int index, CorrelationKeySet correlationKeySet, String routePolicy) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("addRoute " + routeGroupId + " " + target + " " + index + " " + correlationKeySet + " " + routePolicy));
        }
        MessageRouteDAOImpl mr = new MessageRouteDAOImpl(correlationKeySet, routeGroupId, index, (ProcessInstanceDAOImpl)target, this, routePolicy);
        this._routes.add(mr);
        this.getEM().flush();
    }

    @Override
    public MessageExchangeDAO dequeueMessage(CorrelationKeySet correlationKeySet) {
        Iterator<MessageExchangeDAOImpl> itr = this._exchanges.iterator();
        while (itr.hasNext()) {
            MessageExchangeDAOImpl mex = itr.next();
            if (MyRoleMessageExchange.CorrelationStatus.MATCHED.toString().equals(mex.getCorrelationStatus()) || !mex.getCorrelationKeySet().isRoutableTo(correlationKeySet, false)) continue;
            itr.remove();
            return mex;
        }
        return null;
    }

    @Override
    public void enqueueMessage(MessageExchangeDAO mex, CorrelationKeySet correlationKeySet) {
        MessageExchangeDAOImpl mexImpl = (MessageExchangeDAOImpl)mex;
        mexImpl.setCorrelationKeySet(correlationKeySet);
        this._exchanges.add(mexImpl);
        mexImpl.setCorrelator(this);
    }

    @Override
    public Collection<CorrelatorMessageDAO> getAllMessages() {
        return new ArrayList<CorrelatorMessageDAO>(this._exchanges);
    }

    @Override
    public List<MessageRouteDAO> findRoute(CorrelationKeySet correlationKeySet) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("findRoute " + correlationKeySet));
        }
        List<CorrelationKeySet> subSets = correlationKeySet.findSubSets();
        Query qry = this.getEM().createQuery(this.generateSelectorQuery(ROUTE_BY_CKEY_HEADER, subSets));
        qry.setParameter("ptype", (Object)this._process.getType().toString());
        qry.setParameter("corrkey", (Object)this._correlatorKey);
        for (int i = 0; i < subSets.size(); ++i) {
            qry.setParameter("s" + i, (Object)subSets.get(i).toCanonicalString());
        }
        List candidateRoutes = qry.getResultList();
        if (candidateRoutes.size() > 0) {
            ArrayList<MessageRouteDAO> matchingRoutes = new ArrayList<MessageRouteDAO>();
            boolean routed = false;
            for (int i = 0; i < candidateRoutes.size(); ++i) {
                MessageRouteDAO route = (MessageRouteDAO)candidateRoutes.get(i);
                if ("all".equals(route.getRoute())) {
                    matchingRoutes.add(route);
                    continue;
                }
                if (!routed) {
                    matchingRoutes.add(route);
                }
                routed = true;
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("findRoute found " + matchingRoutes));
            }
            return matchingRoutes;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"findRoute found nothing");
        }
        return null;
    }

    private String generateSelectorQuery(String header, List<CorrelationKeySet> subSets) {
        StringBuffer filterQuery = new StringBuffer(header);
        if (subSets.size() == 1) {
            filterQuery.append(" and route._correlationKey = :s0");
        } else if (subSets.size() > 1) {
            filterQuery.append(" and route._correlationKey in(");
            for (int i = 0; i < subSets.size(); ++i) {
                if (i > 0) {
                    filterQuery.append(", ");
                }
                filterQuery.append(":s").append(i);
            }
            filterQuery.append(")");
        }
        return filterQuery.toString();
    }

    @Override
    public String getCorrelatorId() {
        return this._correlatorKey;
    }

    @Override
    public void setCorrelatorId(String newId) {
        this._correlatorKey = newId;
    }

    @Override
    public void removeRoutes(String routeGroupId, ProcessInstanceDAO target) {
        ((ProcessInstanceDAOImpl)target).removeRoutes(routeGroupId);
    }

    void removeLocalRoutes(String routeGroupId, ProcessInstanceDAO target) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("removeLocalRoutes " + routeGroupId));
        }
        boolean flush = false;
        Iterator<MessageRouteDAOImpl> itr = this._routes.iterator();
        while (itr.hasNext()) {
            MessageRouteDAOImpl mr = itr.next();
            if (!mr.getGroupId().equals(routeGroupId) || !mr.getTargetInstance().getInstanceId().equals(target.getInstanceId())) continue;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("removing " + mr.getCorrelationKey() + " " + mr.getIndex() + " " + mr.getRoute()));
            }
            itr.remove();
            this.getEM().remove((Object)mr);
            flush = true;
        }
        if (flush) {
            this.getEM().flush();
        }
    }

    @Override
    public Collection<MessageRouteDAO> getAllRoutes() {
        return new ArrayList<MessageRouteDAO>(this._routes);
    }

    @Override
    public boolean checkRoute(CorrelationKeySet correlationKeySet) {
        return true;
    }

    @Deprecated
    public Long get_correlatorId() {
        return this._correlatorId;
    }

    @Deprecated
    public void set_correlatorId(Long correlatorId) {
        this._correlatorId = correlatorId;
    }
}

