/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.dao.bpel.MessageRouteDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.jpa.bpel.CorrelatorDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessInstanceDAOImpl;

@Entity
@Table(name="BPEL_MESSAGE_ROUTE")
@NamedQueries(value={@NamedQuery(name="DELETE_MESSAGE_ROUTES_BY_INSTANCE_IDS", query="delete from MessageRouteDAOImpl as r where r._instanceId in(:instanceIds)"), @NamedQuery(name="DELETE_MESSAGE_ROUTES_BY_INSTANCE", query="delete from MessageRouteDAOImpl as r where r._processInst = :instance")})
public class MessageRouteDAOImpl
implements MessageRouteDAO {
    public static final String DELETE_MESSAGE_ROUTES_BY_INSTANCE = "DELETE_MESSAGE_ROUTES_BY_INSTANCE";
    public static final String DELETE_MESSAGE_ROUTES_BY_INSTANCE_IDS = "DELETE_MESSAGE_ROUTES_BY_INSTANCE_IDS";
    @Id
    @Column(name="MESSAGE_ROUTE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _id;
    @Basic
    @Column(name="GROUP_ID")
    private String _groupId;
    @Basic
    @Column(name="ROUTE_INDEX")
    private int _index;
    @Basic
    @Column(name="CORRELATION_KEY")
    private String _correlationKey;
    @Basic
    @Column(name="ROUTE_POLICY", length=16)
    private String _routePolicy;
    @Basic
    @Column(name="PROCESS_INSTANCE_ID", insertable=false, updatable=false, nullable=true)
    private Long _instanceId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PROCESS_INSTANCE_ID")
    private ProcessInstanceDAOImpl _processInst;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="CORR_ID")
    private CorrelatorDAOImpl _correlator;

    public MessageRouteDAOImpl() {
    }

    public MessageRouteDAOImpl(CorrelationKeySet keySet, String groupId, int index, ProcessInstanceDAOImpl processInst, CorrelatorDAOImpl correlator, String routePolicy) {
        this._correlationKey = keySet.toCanonicalString();
        this._groupId = groupId;
        this._index = index;
        this._processInst = processInst;
        this._correlator = correlator;
        this._routePolicy = routePolicy;
    }

    @Override
    public CorrelationKey getCorrelationKey() {
        return new CorrelationKey(this._correlationKey);
    }

    @Override
    public void setCorrelationKey(CorrelationKey key) {
        this._correlationKey = key.toCanonicalString();
    }

    @Override
    public String getGroupId() {
        return this._groupId;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public ProcessInstanceDAO getTargetInstance() {
        return this._processInst;
    }

    @Override
    public String getRoute() {
        return this._routePolicy;
    }

    @Override
    public CorrelationKeySet getCorrelationKeySet() {
        return new CorrelationKeySet(this._correlationKey);
    }

    @Override
    public void setCorrelationKeySet(CorrelationKeySet keySet) {
        this._correlationKey = keySet.toCanonicalString();
    }

    public Long getId() {
        return this._id;
    }

    @Deprecated
    public Long get_id() {
        return this._id;
    }

    @Deprecated
    public void set_id(Long id) {
        this._id = id;
    }
}

