/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.ode.dao.jpa.hibernate.HibernateUtil;
import org.apache.ode.utils.DbIsolation;
import org.hibernate.HibernateException;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class DataSourceConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = -2686513656521329257L;
    private Properties _props;
    private boolean available = true;

    public void configure(Map properties) {
        this._props = new Properties();
        this._props.putAll((Map<?, ?>)properties);
    }

    public Connection getConnection() throws SQLException {
        if (!this.available) {
            throw new HibernateException("Provider is closed!");
        }
        Connection c = HibernateUtil.getConnection(this._props);
        DbIsolation.setIsolationLevel(c);
        return c;
    }

    public void closeConnection(Connection con) throws SQLException {
        con.close();
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || DataSourceConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || DataSourceConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void stop() {
        this.available = false;
    }
}

