/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi;

import org.osgi.framework.Bundle;

public class SwitchYardEvent {
    public static final int CREATING = 1;
    public static final int CREATED = 2;
    public static final int DESTROYING = 3;
    public static final int DESTROYED = 4;
    public static final int FAILURE = 5;
    public static final int GRACE_PERIOD = 6;
    private final int _type;
    private final long _timestamp;
    private final Bundle _bundle;
    private final Bundle _extenderBundle;
    private final String[] _dependencies;
    private final Throwable _cause;
    private final boolean _replay;

    public SwitchYardEvent(int type, Bundle bundle, Bundle extenderBundle) {
        this(type, bundle, extenderBundle, null, null);
    }

    public SwitchYardEvent(int type, Bundle bundle, Bundle extenderBundle, String[] dependencies) {
        this(type, bundle, extenderBundle, dependencies, null);
    }

    public SwitchYardEvent(int type, Bundle bundle, Bundle extenderBundle, Throwable cause) {
        this(type, bundle, extenderBundle, null, cause);
    }

    public SwitchYardEvent(int type, Bundle bundle, Bundle extenderBundle, String[] dependencies, Throwable cause) {
        this._type = type;
        this._timestamp = System.currentTimeMillis();
        this._bundle = bundle;
        this._extenderBundle = extenderBundle;
        this._dependencies = dependencies == null ? null : (String[])dependencies.clone();
        this._cause = cause;
        this._replay = false;
        if (bundle == null) {
            throw new NullPointerException("bundle must not be null");
        }
        if (extenderBundle == null) {
            throw new NullPointerException("extenderBundle must not be null");
        }
        switch (type) {
            case 6: {
                if (dependencies == null) {
                    throw new NullPointerException("dependencies must not be null");
                }
                if (dependencies.length != 0) break;
                throw new IllegalArgumentException("dependencies must not be length zero");
            }
            case 5: {
                if (dependencies == null || dependencies.length != 0) break;
                throw new IllegalArgumentException("dependencies must not be length zero");
            }
            default: {
                if (dependencies == null) break;
                throw new IllegalArgumentException("dependencies must be null");
            }
        }
    }

    public SwitchYardEvent(SwitchYardEvent event, boolean replay) {
        this._type = event._type;
        this._timestamp = event._timestamp;
        this._bundle = event._bundle;
        this._extenderBundle = event._extenderBundle;
        this._dependencies = event._dependencies;
        this._cause = event._cause;
        this._replay = replay;
    }

    public int getType() {
        return this._type;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    public Bundle getExtenderBundle() {
        return this._extenderBundle;
    }

    public String[] getDependencies() {
        return this._dependencies == null ? null : (String[])this._dependencies.clone();
    }

    public Throwable getCause() {
        return this._cause;
    }

    public boolean isReplay() {
        return this._replay;
    }
}

