/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.config.Configuration;
import org.switchyard.config.Configurations;
import org.switchyard.deploy.Component;
import org.switchyard.deploy.osgi.base.SimpleExtension;
import org.switchyard.deploy.osgi.internal.SwitchYardExtender;

public class ComponentExtension
extends SimpleExtension {
    public static final String META_INF_COMPONENT = "META-INF/services/org.switchyard.deploy.Component";
    public static final String SWITCHYARD_TYPES = "switchyard.types";
    private final Logger _logger = LoggerFactory.getLogger(SwitchYardExtender.class);
    private final SwitchYardExtender _extender;
    private List<ServiceRegistration<Component>> _registrations = new ArrayList<ServiceRegistration<Component>>();
    private final ServiceTracker<ConfigurationAdmin, ConfigurationAdmin> _configTracker;
    private ConfigurationAdmin _configAdmin;

    public ComponentExtension(SwitchYardExtender extender, Bundle bundle) {
        super(bundle);
        this._extender = extender;
        this._configTracker = new ServiceTracker(bundle.getBundleContext(), ConfigurationAdmin.class, null);
        this._configTracker.open();
    }

    @Override
    protected void doStart() throws Exception {
        this._configAdmin = (ConfigurationAdmin)this._configTracker.waitForService(0L);
        URL url = this.getBundle().getEntry(META_INF_COMPONENT);
        List<String> classNames = this.parse(Component.class, url);
        for (String className : classNames) {
            Component component = this.initializeComponent(className);
            Hashtable<String, List> props = new Hashtable<String, List>();
            ((Dictionary)props).put(SWITCHYARD_TYPES, component.getActivationTypes());
            ServiceRegistration reg = this.getBundleContext().registerService(Component.class, (Object)component, props);
            this._registrations.add((ServiceRegistration<Component>)reg);
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        for (ServiceRegistration<Component> reg : this._registrations) {
            reg.unregister();
        }
        this._configTracker.close();
    }

    private Component initializeComponent(String className) throws Exception {
        Class clazz = this.getBundle().loadClass(className);
        Component component = (Component)clazz.newInstance();
        String configName = className.contains("org.switchyard.component") && className.indexOf(".deploy") > 0 ? className.substring(0, className.indexOf(".deploy")) : component.getName();
        Configuration config = this.loadConfiguration(configName);
        component.init(config);
        return component;
    }

    private Configuration loadConfiguration(String configName) throws Exception {
        Configuration syConfig = Configurations.newConfiguration();
        org.osgi.service.cm.Configuration osgiConfig = this._configAdmin.getConfiguration(configName, null);
        Dictionary props = osgiConfig.getProperties();
        if (props != null) {
            Enumeration keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Configuration config = Configurations.newConfiguration((String)key);
                config.setValue((String)props.get(key));
                syConfig.addChild(config);
            }
        }
        return syConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> parse(Class service, URL u) {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            ComponentExtension.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ComponentExtension.fail(service, "Error closing configuration file", y);
            }
        }
        return names;
    }

    private int parseLine(Class service, URL u, BufferedReader r, int lc, List<String> names) throws IOException {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ComponentExtension.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ComponentExtension.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ComponentExtension.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    private static void fail(Class service, String msg, Throwable cause) {
        throw new IllegalStateException(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class service, String msg) {
        throw new IllegalStateException(service.getName() + ": " + msg);
    }

    private static void fail(Class service, URL u, int line, String msg) {
        ComponentExtension.fail(service, u + ":" + line + ": " + msg);
    }
}

