/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.deploy.Component;
import org.switchyard.deploy.osgi.ComponentRegistry;
import org.switchyard.deploy.osgi.internal.NamespaceHandlerRegistryImpl;

public class ComponentRegistryImpl
implements ComponentRegistry,
ServiceTrackerCustomizer<Component, Component> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceHandlerRegistryImpl.class);
    private final BundleContext _bundleContext;
    private final ServiceTracker<Component, Component> _tracker;
    private final List<ComponentRegistry.Listener> _listeners = new CopyOnWriteArrayList<ComponentRegistry.Listener>();
    private final List<Component> _components = new CopyOnWriteArrayList<Component>();

    public ComponentRegistryImpl(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._tracker = new ServiceTracker(bundleContext, Component.class, (ServiceTrackerCustomizer)this);
        this._tracker.open();
    }

    @Override
    public Component getComponent(String type) {
        for (Component component : this._components) {
            if (!component.getActivationTypes().contains(type)) continue;
            return component;
        }
        return null;
    }

    @Override
    public void addListener(ComponentRegistry.Listener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(ComponentRegistry.Listener listener) {
        this._listeners.remove(listener);
    }

    public Component addingService(ServiceReference<Component> reference) {
        Component component = (Component)this._bundleContext.getService(reference);
        this.registerComponent(component);
        return component;
    }

    public void modifiedService(ServiceReference<Component> reference, Component component) {
        this.unregisterComponent(component);
        this.registerComponent(component);
    }

    public void removedService(ServiceReference<Component> reference, Component component) {
        this.unregisterComponent(component);
    }

    @Override
    public void destroy() {
        this._tracker.close();
    }

    private void registerComponent(Component component) {
        this._components.add(component);
        for (ComponentRegistry.Listener listener : this._listeners) {
            for (String type : component.getActivationTypes()) {
                listener.componentRegistered(type);
            }
        }
    }

    private void unregisterComponent(Component component) {
        for (ComponentRegistry.Listener listener : this._listeners) {
            for (String type : component.getActivationTypes()) {
                listener.componentUnregistered(type);
            }
        }
        component.destroy();
        this._components.remove(component);
    }
}

