/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.switchyard.common.util.ProviderRegistry;

public class ProviderRegistryImpl
implements ProviderRegistry.Registry,
BundleTrackerCustomizer<Bundle> {
    public static final long DEFAULT_TIMEOUT = 0L;
    public static final String TIMEOUT = "org.switchyard.providers.timeout";
    private Map<String, List<Callable<Class>>> _factories;
    private final ReadWriteLock _lock = new ReentrantReadWriteLock();
    private final BundleContext _bundleContext;
    private final BundleTracker<Bundle> _tracker;
    private final ConcurrentMap<Long, Map<String, Callable<Class>>> allFactories = new ConcurrentHashMap<Long, Map<String, Callable<Class>>>();

    public ProviderRegistryImpl(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._tracker = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)this);
        this._tracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getProvider(Class<T> clazz) {
        try {
            Object provider = null;
            Class<T> pvdClass = this.locate(clazz);
            if (pvdClass != null) {
                provider = pvdClass.newInstance();
            } else {
                ServiceReference ref = this._bundleContext.getServiceReference(clazz);
                if (ref != null) {
                    provider = this._bundleContext.getService(ref);
                } else {
                    ServiceTracker tracker = new ServiceTracker(this._bundleContext, clazz, null);
                    try {
                        tracker.open();
                        provider = tracker.waitForService(10000L);
                    }
                    finally {
                        tracker.close();
                    }
                }
            }
            return (T)provider;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> getProviders(Class<T> clazz) {
        try {
            ArrayList<T> providers = new ArrayList<T>();
            List<Class<T>> pvds = this.locateAll(clazz);
            for (Class<T> pvd : pvds) {
                providers.add(pvd.newInstance());
            }
            return providers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        this._tracker.close();
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        this.register(bundle);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        this.unregister(bundle.getBundleId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String id, Callable<Class> factory) {
        this._lock.writeLock().lock();
        try {
            List<Callable<Class>> l;
            if (this._factories == null) {
                this._factories = new HashMap<String, List<Callable<Class>>>();
            }
            if ((l = this._factories.get(id)) == null) {
                l = new ArrayList<Callable<Class>>();
                this._factories.put(id, l);
            }
            l.add(0, factory);
            ReadWriteLock readWriteLock = this._lock;
            synchronized (readWriteLock) {
                this._lock.notifyAll();
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String id, Callable<Class> factory) {
        this._lock.writeLock().lock();
        try {
            List<Callable<Class>> l;
            if (this._factories != null && (l = this._factories.get(id)) != null) {
                l.remove(factory);
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public <T> Class<? extends T> locate(Class<T> factoryId) {
        return this.locate(factoryId, factoryId.getName());
    }

    private static long getTimeout() {
        long timeout = 0L;
        try {
            String prop = System.getProperty(TIMEOUT);
            if (prop != null) {
                timeout = Long.parseLong(prop);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Class<? extends T> locate(Class<T> factoryClass, String factoryId) {
        long t0;
        long timeout = ProviderRegistryImpl.getTimeout();
        if (timeout <= 0L) {
            return this.doLocate(factoryClass, factoryId);
        }
        long t1 = t0 = System.currentTimeMillis();
        while (t1 - t0 < timeout) {
            Class<T> impl = this.doLocate(factoryClass, factoryId);
            if (impl != null) {
                return impl;
            }
            ReadWriteLock readWriteLock = this._lock;
            synchronized (readWriteLock) {
                try {
                    this._lock.wait(timeout - (t1 - t0));
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            t1 = System.currentTimeMillis();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Class<? extends T> doLocate(Class<T> factoryClass, String factoryId) {
        this._lock.readLock().lock();
        try {
            List<Callable<Class>> l;
            if (this._factories != null && (l = this._factories.get(factoryId)) != null && !l.isEmpty()) {
                String factoryClassName = System.getProperty(factoryId);
                try {
                    for (Callable<Class> i : l) {
                        Class c = null;
                        try {
                            c = i.call();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (c == null || factoryClass != c.getClassLoader().loadClass(factoryClass.getName()) || factoryClassName != null && !c.getName().equals(factoryClassName)) continue;
                        Class clazz = c;
                        return clazz;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Class<? extends T> clazz = null;
            return clazz;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public <T> List<Class<? extends T>> locateAll(Class<T> factoryId) {
        return this.locateAll(factoryId, factoryId.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<Class<? extends T>> locateAll(Class<T> factoryClass, String factoryId) {
        this._lock.readLock().lock();
        try {
            List<Callable<Class>> l;
            ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
            if (this._factories != null && (l = this._factories.get(factoryId)) != null) {
                for (Callable<Class> i : l) {
                    try {
                        Class c = i.call();
                        if (c == null || !factoryClass.isAssignableFrom(c)) continue;
                        classes.add(c);
                    }
                    catch (Exception exception) {}
                }
            }
            ArrayList<Class<T>> arrayList = classes;
            return arrayList;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    protected void register(Bundle bundle) {
        HashMap<String, BundleFactoryLoader> map = (HashMap<String, BundleFactoryLoader>)this.allFactories.get(bundle.getBundleId());
        Enumeration e = bundle.findEntries("META-INF/services/", "*", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                String url = u.toString();
                if (url.endsWith("/")) continue;
                String factoryId = url.substring(url.lastIndexOf("/") + 1);
                if (map == null) {
                    map = new HashMap<String, BundleFactoryLoader>();
                    this.allFactories.put(bundle.getBundleId(), map);
                }
                map.put(factoryId, new BundleFactoryLoader(factoryId, u, bundle));
            }
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.register((String)entry.getKey(), (Callable)entry.getValue());
            }
        }
    }

    protected void unregister(long bundleId) {
        Map map = (Map)this.allFactories.remove(bundleId);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.unregister((String)entry.getKey(), (Callable)entry.getValue());
            }
        }
    }

    private class BundleFactoryLoader
    implements Callable<Class> {
        private final String factoryId;
        private final URL u;
        private final Bundle bundle;
        private volatile Class<?> clazz;

        public BundleFactoryLoader(String factoryId, URL u, Bundle bundle) {
            this.factoryId = factoryId;
            this.u = u;
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Class call() throws Exception {
            try {
                if (this.clazz == null) {
                    BundleFactoryLoader bundleFactoryLoader = this;
                    synchronized (bundleFactoryLoader) {
                        if (this.clazz == null) {
                            BufferedReader br = new BufferedReader(new InputStreamReader(this.u.openStream(), "UTF-8"));
                            try {
                                String factoryClassName = br.readLine();
                                while (factoryClassName != null) {
                                    if ((factoryClassName = factoryClassName.trim()).charAt(0) != '#') {
                                        this.clazz = this.bundle.loadClass(factoryClassName);
                                        Class<?> clazz = this.clazz;
                                        return clazz;
                                    }
                                    factoryClassName = br.readLine();
                                }
                            }
                            finally {
                                br.close();
                            }
                        }
                    }
                }
                return this.clazz;
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
        }

        public String toString() {
            return this.u.toString();
        }

        public int hashCode() {
            return this.u.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BundleFactoryLoader) {
                return this.u.equals(((BundleFactoryLoader)obj).u);
            }
            return false;
        }
    }
}

