/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.ServiceDomain;
import org.switchyard.admin.SwitchYard;
import org.switchyard.admin.base.SwitchYardBuilder;
import org.switchyard.common.util.ProviderRegistry;
import org.switchyard.config.Configuration;
import org.switchyard.deploy.ServiceDomainManager;
import org.switchyard.deploy.osgi.ComponentRegistry;
import org.switchyard.deploy.osgi.NamespaceHandlerRegistry;
import org.switchyard.deploy.osgi.SwitchYardListener;
import org.switchyard.deploy.osgi.base.AbstractExtender;
import org.switchyard.deploy.osgi.base.CompoundExtension;
import org.switchyard.deploy.osgi.base.Extension;
import org.switchyard.deploy.osgi.internal.ComponentExtension;
import org.switchyard.deploy.osgi.internal.ComponentRegistryImpl;
import org.switchyard.deploy.osgi.internal.ConfigurationExtension;
import org.switchyard.deploy.osgi.internal.NamespaceHandlerRegistryImpl;
import org.switchyard.deploy.osgi.internal.OsgiDomainManager;
import org.switchyard.deploy.osgi.internal.ProviderRegistryImpl;
import org.switchyard.deploy.osgi.internal.SwitchYardContainerImpl;
import org.switchyard.deploy.osgi.internal.SwitchYardEventDispatcher;
import org.switchyard.deploy.osgi.internal.SwitchYardThreadFactory;

public class SwitchYardExtender
extends AbstractExtender {
    public static final String SWITCHYARD_XML = "META-INF/switchyard.xml";
    public static final String WEBINF_SWITCHYARD_XML = "WEB-INF/switchyard.xml";
    private final Logger _logger = LoggerFactory.getLogger(SwitchYardExtender.class);
    private NamespaceHandlerRegistry _namespaceHandlerRegistry;
    private ComponentRegistry _componentRegistry;
    private ProviderRegistryImpl _providerRegistry;
    private OsgiDomainManager _domainManager = new OsgiDomainManager(this);
    private SwitchYardEventDispatcher _eventDispatcher;
    private Runnable _management;

    @Override
    protected void doStart() throws Exception {
        try {
            this._management = this.createManagement(this._domainManager);
        }
        catch (NoClassDefFoundError e) {
            this._logger.warn("Management support disabled (package not available)", (Throwable)e);
        }
        this._eventDispatcher = new SwitchYardEventDispatcher(this.getBundleContext(), this.getExecutors());
        this._namespaceHandlerRegistry = new NamespaceHandlerRegistryImpl(this.getBundleContext());
        this._componentRegistry = new ComponentRegistryImpl(this.getBundleContext());
        this._providerRegistry = new ProviderRegistryImpl(this.getBundleContext());
        ProviderRegistry.setRegistry((ProviderRegistry.Registry)this._providerRegistry);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._management != null) {
            this._management.run();
            this._management = null;
        }
        ProviderRegistry.setRegistry(null);
        this._providerRegistry.destroy();
        this._componentRegistry.destroy();
        this._namespaceHandlerRegistry.destroy();
        this._eventDispatcher.destroy();
    }

    @Override
    protected ExecutorService createExecutor() {
        return Executors.newScheduledThreadPool(3, new SwitchYardThreadFactory("Switchyard Extender"));
    }

    public NamespaceHandlerRegistry getNamespaceHandlerRegistry() {
        return this._namespaceHandlerRegistry;
    }

    public ComponentRegistry getComponentRegistry() {
        return this._componentRegistry;
    }

    public OsgiDomainManager getDomainManager() {
        return this._domainManager;
    }

    public SwitchYardListener getEventDispatcher() {
        return this._eventDispatcher;
    }

    @Override
    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        URL swXml;
        URL swCmp;
        if (!this.checkCompatible(bundle, ServiceDomain.class, Configuration.class)) {
            return null;
        }
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        URL swCfg = bundle.getEntry("/org/switchyard/config/model/descriptor.properties");
        if (swCfg != null) {
            extensions.add(new ConfigurationExtension(this, bundle));
        }
        if ((swCmp = bundle.getEntry("META-INF/services/org.switchyard.deploy.Component")) != null) {
            extensions.add(new ComponentExtension(this, bundle));
        }
        if ((swXml = bundle.getEntry(SWITCHYARD_XML)) == null) {
            swXml = bundle.getEntry(WEBINF_SWITCHYARD_XML);
        }
        if (swXml != null) {
            extensions.add(new SwitchYardContainerImpl(this, bundle, this.getExecutors()));
        }
        return extensions.isEmpty() ? null : new CompoundExtension(bundle, extensions);
    }

    private boolean checkCompatible(Bundle bundle, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            try {
                Class loaded = bundle.loadClass(clazz.getName());
                if (loaded == null || loaded == clazz) continue;
                return false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected void debug(Bundle bundle, String msg) {
        this._logger.debug("Switchyard extender for bundle " + bundle + ": " + msg);
    }

    @Override
    protected void warn(Bundle bundle, String msg, Throwable t) {
        this._logger.warn("Switchyard extender for bundle " + bundle + ": " + msg, t);
    }

    @Override
    protected void error(String msg, Throwable t) {
        this._logger.debug("Switchyard extender: " + msg, t);
    }

    private Runnable createManagement(ServiceDomainManager manager) {
        final SwitchYardBuilder builder = new SwitchYardBuilder();
        builder.init(manager);
        final ServiceRegistration reg = this.getBundleContext().registerService(SwitchYard.class, (Object)builder.getSwitchYard(), null);
        return new Runnable(){

            @Override
            public void run() {
                reg.unregister();
                builder.destroy();
            }
        };
    }
}

