/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import org.apache.log4j.Layout;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.ops4j.pax.logging.service.internal.PaxLoggingEventImpl;
import org.ops4j.pax.logging.spi.PaxLayout;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class LayoutBridgeImpl
extends Layout {
    private ServiceTracker m_tracker;
    private Layout m_fallback;

    public LayoutBridgeImpl(BundleContext bundleContext, String name, Layout fallback) {
        this.m_tracker = new ServiceTracker(bundleContext, LayoutBridgeImpl.createFilter(bundleContext, name), null);
        this.m_tracker.open();
        this.m_fallback = fallback != null ? fallback : new SimpleLayout();
    }

    public static Filter createFilter(BundleContext bundleContext, String name) {
        try {
            return bundleContext.createFilter("(&(objectClass=" + PaxLayout.class.getName() + ")" + "(" + "org.ops4j.pax.logging.layout.name" + "=" + name + "))");
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("unable to create layout tracker", e);
        }
    }

    @Override
    public String format(LoggingEvent event) {
        PaxLayout layout = (PaxLayout)this.m_tracker.getService();
        if (layout != null) {
            return layout.doLayout(new PaxLoggingEventImpl(event));
        }
        return this.m_fallback.format(event);
    }

    @Override
    public boolean ignoresThrowable() {
        return true;
    }

    @Override
    public void activateOptions() {
    }

    @Override
    public String getContentType() {
        String contentType;
        PaxLayout layout = (PaxLayout)this.m_tracker.getService();
        if (layout != null && (contentType = layout.getContentType()) != null) {
            return contentType;
        }
        return this.m_fallback.getContentType();
    }

    @Override
    public String getHeader() {
        PaxLayout layout = (PaxLayout)this.m_tracker.getService();
        if (layout != null) {
            return layout.getHeader();
        }
        return this.m_fallback.getHeader();
    }

    @Override
    public String getFooter() {
        PaxLayout layout = (PaxLayout)this.m_tracker.getService();
        if (layout != null) {
            return layout.getFooter();
        }
        return this.m_fallback.getFooter();
    }
}

