/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExecutorServiceWrapper
extends AbstractExecutorService
implements Runnable {
    private final ExecutorService _delegate;
    private final ConcurrentLinkedQueue<Runnable> _queue = new ConcurrentLinkedQueue();
    private final AtomicBoolean _triggered = new AtomicBoolean();
    private final AtomicBoolean _shutdown = new AtomicBoolean();
    private Thread _runningThread;

    public ExecutorServiceWrapper(ExecutorService delegate) {
        this._delegate = delegate;
    }

    @Override
    public void shutdown() {
        this._shutdown.set(true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> pending = new ArrayList<Runnable>();
        if (this._shutdown.compareAndSet(false, true)) {
            Runnable runnable;
            while ((runnable = this._queue.poll()) != null) {
                pending.add(runnable);
            }
        }
        return pending;
    }

    @Override
    public boolean isShutdown() {
        return this._shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this._delegate.isTerminated() || this.isShutdown() && this._queue.isEmpty() && !this._triggered.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long millis = unit.toMillis(timeout);
        if (millis > 0L) {
            long max = System.currentTimeMillis() + millis;
            AtomicBoolean atomicBoolean = this._triggered;
            synchronized (atomicBoolean) {
                while (System.currentTimeMillis() < max) {
                    if (this.isTerminated()) {
                        return true;
                    }
                    this._triggered.wait(millis);
                }
            }
        }
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable command) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Executor has been shut down");
        }
        this._queue.add(command);
        this.triggerExecution();
    }

    protected void triggerExecution() {
        if (this._triggered.compareAndSet(false, true)) {
            this._delegate.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AtomicBoolean atomicBoolean;
        try {
            atomicBoolean = this._triggered;
            synchronized (atomicBoolean) {
                this._runningThread = Thread.currentThread();
            }
            while (true) {
                Runnable runnable;
                if ((runnable = this._queue.poll()) == null) {
                    return;
                }
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                }
            }
        }
        finally {
            atomicBoolean = this._triggered;
            synchronized (atomicBoolean) {
                this._runningThread = null;
                this._triggered.set(false);
                this._triggered.notifyAll();
            }
            if (!this.isShutdown() && !this._queue.isEmpty()) {
                this.triggerExecution();
            }
        }
    }
}

