/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.validation.Schema;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.ServiceDomain;
import org.switchyard.common.io.pull.ElementPuller;
import org.switchyard.common.property.CompoundPropertyResolver;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Marshaller;
import org.switchyard.config.model.ModelPuller;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.Component;
import org.switchyard.deploy.internal.Deployment;
import org.switchyard.deploy.osgi.ComponentRegistry;
import org.switchyard.deploy.osgi.NamespaceHandler;
import org.switchyard.deploy.osgi.NamespaceHandlerSet;
import org.switchyard.deploy.osgi.SwitchYardContainer;
import org.switchyard.deploy.osgi.SwitchYardEvent;
import org.switchyard.deploy.osgi.base.SimpleExtension;
import org.switchyard.deploy.osgi.internal.ExecutorServiceWrapper;
import org.switchyard.deploy.osgi.internal.SwitchYardExtender;
import org.switchyard.transform.internal.DuplicateTransformerException;
import org.switchyard.transform.internal.TransformerRegistryLoader;
import org.switchyard.transform.osgi.internal.TransformSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SwitchYardContainerImpl
extends SimpleExtension
implements NamespaceHandlerSet.Listener,
ComponentRegistry.Listener,
Runnable,
SwitchYardContainer {
    public static final String SWITCHYARD_DEPLOYMENT_BUNDLE = "switchyard.deployment.bundle";
    public static final String CONTAINER_SYMBOLIC_NAME_PROPERTY = "switchyard.container.symbolicname";
    public static final String CONTAINER_VERSION_PROPERTY = "switchyard.container.version";
    private static final Logger logger = LoggerFactory.getLogger(SwitchYardExtender.class);
    private final SwitchYardExtender _extender;
    private final Bundle _extenderBundle;
    private State _state = State.Unknown;
    private Element _xml;
    private SwitchYardModel _model;
    private Set<URI> _namespaces;
    private NamespaceHandlerSet _nhs;
    private Set<String> _types;
    private ServiceDomain _domain;
    private Deployment _deployment;
    private final AtomicBoolean _scheduled = new AtomicBoolean();
    private final AtomicBoolean _destroyed = new AtomicBoolean(false);
    private final ExecutorService _executors;
    private ServiceRegistration<SwitchYardContainer> _registration;
    private ServiceTracker _cdiContainerTracker;
    private Object _cdiContainer;

    public SwitchYardContainerImpl(SwitchYardExtender extender, Bundle bundle, ExecutorService executor) {
        super(bundle);
        this._extender = extender;
        this._extenderBundle = extender.getBundleContext().getBundle();
        this._executors = executor != null ? new ExecutorServiceWrapper(executor) : null;
    }

    @Override
    protected Object getLock() {
        return this._scheduled;
    }

    public void schedule() {
        if (this._scheduled.compareAndSet(false, true) && !this._destroyed.get()) {
            this._executors.submit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._scheduled.set(false);
        AtomicBoolean atomicBoolean = this._scheduled;
        synchronized (atomicBoolean) {
            this.doStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void doStart() {
        tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((BundleWiring)this._bundle.adapt(BundleWiring.class)).getClassLoader());
            while (true) {
                if (this._destroyed.get()) {
                    return;
                }
                if (this._bundle.getState() != 32 && this._bundle.getState() != 8) {
                    return;
                }
                if (this._bundle.getBundleContext() != this._bundleContext) {
                    return;
                }
                SwitchYardContainerImpl.logger.debug("Running switchyard container for bundle {} in state {}", (Object)this._bundle.getSymbolicName(), (Object)this._state);
                switch (3.$SwitchMap$org$switchyard$deploy$osgi$internal$SwitchYardContainerImpl$State[this._state.ordinal()]) {
                    case 1: {
                        this.dispatch(1);
                        needsCdi = false;
                        wires = ((BundleWiring)this._bundle.adapt(BundleWiring.class)).getRequiredWires("osgi.extender");
                        for (BundleWire wire : wires) {
                            filterStr = (String)wire.getRequirement().getDirectives().get("filter");
                            filter = FrameworkUtil.createFilter((String)filterStr);
                            props = new Hashtable<String, String>();
                            props.put("osgi.extender", "pax.cdi");
                            needsCdi = filter.match(props);
                        }
                        if (needsCdi) {
                            filter = "(&(objectClass=org.ops4j.pax.cdi.spi.CdiContainer)(bundleId=" + this._bundle.getBundleId() + "))";
                            this._cdiContainerTracker = new ServiceTracker(this._bundleContext, FrameworkUtil.createFilter((String)filter), new ServiceTrackerCustomizer(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Object addingService(ServiceReference reference) {
                                    AtomicBoolean atomicBoolean = SwitchYardContainerImpl.this._scheduled;
                                    synchronized (atomicBoolean) {
                                        SwitchYardContainerImpl.this._cdiContainer = SwitchYardContainerImpl.this._bundleContext.getService(reference);
                                    }
                                    SwitchYardContainerImpl.this.schedule();
                                    return SwitchYardContainerImpl.this._cdiContainer;
                                }

                                public void modifiedService(ServiceReference reference, Object service) {
                                }

                                public void removedService(ServiceReference reference, Object service) {
                                    SwitchYardContainerImpl.this._bundleContext.ungetService(reference);
                                    SwitchYardContainerImpl.this.enterGracePeriod();
                                }
                            });
                            this._cdiContainerTracker.open();
                        }
                        this._state = State.WaitForCdi;
                        break;
                    }
                    case 2: {
                        if (this._cdiContainerTracker != null && this._cdiContainer == null) {
                            filter = "(&(objectClass=org.ops4j.pax.cdi.spi.CdiContainer)(bundleId=" + this._bundle.getBundleId() + "))";
                            this.dispatch(6, Collections.singleton(filter));
                            return;
                        }
                        if (this._nhs != null) ** GOTO lbl50
                        configUrl = this.getBundle().getEntry("META-INF/switchyard.xml");
                        if (configUrl == null) {
                            configUrl = this.getBundle().getEntry("WEB-INF/switchyard.xml");
                        }
                        configStream = configUrl.openStream();
                        try {
                            this._xml = new ElementPuller().pull(configStream);
                        }
                        finally {
                            configStream.close();
                        }
                        this._namespaces = this.findNamespaces(new HashSet<URI>(), this._xml);
                        this._nhs = this._extender.getNamespaceHandlerRegistry().getNamespaceHandlers(this._namespaces, this.getBundle());
                        this._nhs.addListener(this);
lbl50:
                        // 2 sources

                        this._state = State.WaitForNamespaceHandlers;
                        break;
                    }
                    case 3: {
                        missing = new ArrayList<String>();
                        missingURIs = new ArrayList<URI>();
                        for (URI ns : this._namespaces) {
                            if (this._nhs.getNamespaceHandler(ns) != null) continue;
                            missing.add("(&(objectClass=" + NamespaceHandler.class.getName() + ")(" + "switchyard.namespaces" + "=" + ns + "))");
                            missingURIs.add(ns);
                            this.dispatch(6, missing);
                        }
                        if (missing.size() > 0) {
                            SwitchYardContainerImpl.logger.info("Bundle {} is waiting for namespace handlers {}", (Object)this.getBundle().getSymbolicName(), missingURIs);
                            return;
                        }
                        this._model = (SwitchYardModel)new ModelPuller((Descriptor)new OsgiDescriptor(this._nhs)).pull(this._xml);
                        OsgiPropertyResolver.access$500(this._model, this._bundle);
                        this._types = new HashSet<String>();
                        if (this._model.getComposite() != null) {
                            for (CompositeReferenceModel reference : this._model.getComposite().getReferences()) {
                                for (BindingModel binding : reference.getBindings()) {
                                    this._types.add(binding.getType());
                                }
                            }
                            for (ComponentModel component : this._model.getComposite().getComponents()) {
                                impl = component.getImplementation();
                                if (impl == null) {
                                    throw new IllegalStateException("Component implementation should not be null");
                                }
                                this._types.add(impl.getType());
                            }
                            for (CompositeServiceModel service : this._model.getComposite().getServices()) {
                                for (BindingModel binding : service.getBindings()) {
                                    this._types.add(binding.getType());
                                }
                            }
                        } else {
                            SwitchYardContainerImpl.logger.info("A composite element is missing from the switchyard.xml");
                        }
                        this._extender.getComponentRegistry().addListener(this);
                        this._state = State.WaitForComponents;
                        break;
                    }
                    case 4: {
                        components = new ArrayList<Component>();
                        missingTypes = new ArrayList<String>();
                        for (String type : this._types) {
                            component = this._extender.getComponentRegistry().getComponent(type);
                            if (component == null) {
                                missingTypes.add(type);
                                continue;
                            }
                            components.add(component);
                        }
                        if (!missingTypes.isEmpty()) {
                            SwitchYardContainerImpl.logger.info("Bundle {} is waiting for components {}", (Object)this.getBundle().getSymbolicName(), missingTypes);
                            this.dispatch(6, missingTypes);
                            return;
                        }
                        newTccl = oldTccl = Thread.currentThread().getContextClassLoader();
                        if (this._cdiContainer != null) {
                            try {
                                method = this._cdiContainer.getClass().getMethod("getContextClassLoader", new Class[0]);
                                newTccl = (ClassLoader)method.invoke(this._cdiContainer, new Object[0]);
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        try {
                            Thread.currentThread().setContextClassLoader(newTccl);
                            this._domain = this._extender.getDomainManager().createDomain(this.getBundleContext(), this._model.getQName(), this._model);
                            this._domain.setProperty("switchyard.deployment.bundle", (Object)this.getBundle());
                            this.registerOOTBTransformers();
                            activators = new ArrayList<Activator>();
                            for (Component component : components) {
                                activators.add(component.createActivator(this._domain));
                            }
                            this._deployment = new Deployment(this._model);
                            this._deployment.init(this._domain, activators);
                            this._deployment.start();
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(oldTccl);
                        }
                        bs = this._bundle.getState();
                        if (this._registration == null && (bs == 32 || bs == 8)) {
                            props = new Hashtable<String, String>();
                            props.put("switchyard.container.symbolicname", this._bundle.getSymbolicName());
                            props.put("switchyard.container.version", (String)this._bundle.getVersion());
                            this._registration = this._bundleContext.registerService(SwitchYardContainer.class, (Object)this, props);
                        }
                        this.dispatch(2);
                        this._state = State.Created;
                        break;
                    }
                    case 5: 
                    case 6: {
                        return;
                    }
                }
                continue;
                break;
            }
            catch (Throwable t) {
                try {
                    this._state = State.Failed;
                    SwitchYardContainerImpl.logger.error("Unable to start switchyard for bundle " + this.getBundle().getSymbolicName(), t);
                    this.dispatch(5, t);
                    this.destroyDeployment();
                }
                catch (RuntimeException re) {
                    SwitchYardContainerImpl.logger.debug("Tidying up components failed. ", (Throwable)re);
                    throw re;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        this.dispatch(3);
        this._executors.shutdownNow();
        try {
            if (this._registration != null) {
                this._registration.unregister();
                this._registration = null;
            }
        }
        catch (Throwable t) {
            logger.debug("Error unregistering Switchyard container", t);
        }
        if (this._cdiContainerTracker != null) {
            this._cdiContainerTracker.close();
            this._cdiContainerTracker = null;
        }
        if (this._nhs != null) {
            this._nhs.removeListener(this);
            this._nhs.destroy();
            this._nhs = null;
        }
        try {
            this._executors.awaitTermination(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.debug("Interrupted waiting for executor to shut down");
        }
        this.destroyDeployment();
        this.dispatch(4);
        logger.debug("Switchyard container destroyed: {}", (Object)this._bundleContext);
    }

    private void dispatch(int type) {
        this.dispatch(new SwitchYardEvent(type, this.getBundle(), this._extenderBundle));
    }

    private void dispatch(int type, Collection<String> deps) {
        String[] depsArray = deps.toArray(new String[deps.size()]);
        this.dispatch(new SwitchYardEvent(type, this.getBundle(), this._extenderBundle, depsArray));
    }

    private void dispatch(int type, Throwable t) {
        this.dispatch(new SwitchYardEvent(type, this.getBundle(), this._extenderBundle, t));
    }

    private void dispatch(SwitchYardEvent event) {
        this._extender.getEventDispatcher().switchyardEvent(event);
    }

    @Override
    public void namespaceHandlerRegistered(URI uri) {
        if (this._nhs.isComplete()) {
            this.schedule();
        }
    }

    @Override
    public void namespaceHandlerUnregistered(URI uri) {
        if (!this._nhs.isComplete()) {
            this.enterGracePeriod();
        }
    }

    @Override
    public void componentRegistered(String type) {
        if (this._types != null && this._types.contains(type)) {
            this.schedule();
        }
    }

    @Override
    public void componentUnregistered(String type) {
        if (this._types != null && this._types.contains(type)) {
            this.enterGracePeriod();
        }
    }

    private void destroyDeployment() {
        this._extender.getComponentRegistry().removeListener(this);
        if (this._deployment != null) {
            this._deployment.stop();
            this._deployment.destroy();
            this._deployment = null;
        }
        if (this._domain != null) {
            this._domain.destroy();
            this._domain = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterGracePeriod() {
        AtomicBoolean atomicBoolean = this._scheduled;
        synchronized (atomicBoolean) {
            if (this._destroyed.get()) {
                return;
            }
            try {
                this.destroyDeployment();
            }
            catch (Exception e) {
                logger.error("Error while stopping switchyard", (Throwable)e);
            }
            this._cdiContainer = null;
            this._state = State.WaitForCdi;
            this.schedule();
        }
    }

    private Set<URI> findNamespaces(Set<URI> namespaces, Node node) {
        NamedNodeMap nnm;
        String ns;
        if ((node instanceof Element || node instanceof Attr) && (ns = node.getNamespaceURI()) != null && !this.isIgnorableAttributeNamespace(ns)) {
            namespaces.add(URI.create(ns));
        }
        if ((nnm = node.getAttributes()) != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                this.findNamespaces(namespaces, nnm.item(i));
            }
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            this.findNamespaces(namespaces, nl.item(i));
        }
        return namespaces;
    }

    private boolean isIgnorableAttributeNamespace(String ns) {
        return "http://relaxng.org/ns/structure/1.0".equals(ns) || "http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/2001/XMLSchema".equals(ns) || "http://www.w3.org/2003/11/xpath-datatypes".equals(ns) || "http://www.w3.org/2003/11/xpath-datatypes".equals(ns) || "http://www.w3.org/TR/REC-xml".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns) || "http://www.w3.org/2000/xmlns/".equals(ns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOOTBTransformers() throws Exception {
        Collection refs = this._bundleContext.getServiceReferences(TransformSource.class, null);
        for (final ServiceReference ref : refs) {
            TransformerRegistryLoader loader = new TransformerRegistryLoader(this._domain.getTransformerRegistry()){

                protected Class<?> getClass(String className) {
                    Class clazz = null;
                    try {
                        clazz = ref.getBundle().loadClass(className);
                    }
                    catch (ClassNotFoundException ex) {
                        logger.warn("Failed to load transformer class " + className + " from bundle " + ref.getBundle().getSymbolicName());
                    }
                    return clazz;
                }
            };
            TransformSource trs = (TransformSource)this._bundleContext.getService(ref);
            InputStream tStream = null;
            try {
                tStream = trs.getTransformsURL().openStream();
                Element tConfig = new ElementPuller().pull(tStream);
                Set<URI> tNamespaces = this.findNamespaces(new HashSet<URI>(), tConfig);
                NamespaceHandlerSet tHandlers = this._extender.getNamespaceHandlerRegistry().getNamespaceHandlers(tNamespaces, this.getBundle());
                TransformsModel tm = (TransformsModel)new ModelPuller((Descriptor)new OsgiDescriptor(tHandlers)).pull(tConfig);
                loader.registerTransformers(tm, false);
            }
            catch (DuplicateTransformerException e) {
                logger.debug(e.getMessage());
            }
            catch (Exception ex) {
                logger.warn("Failed to load transformers from bundle: " + ref.getBundle().getSymbolicName(), (Throwable)ex);
            }
            finally {
                if (tStream != null) {
                    tStream.close();
                }
                this._bundleContext.ungetService(ref);
            }
        }
    }

    static class 3 {
        static final /* synthetic */ int[] $SwitchMap$org$switchyard$deploy$osgi$internal$SwitchYardContainerImpl$State;

        static {
            $SwitchMap$org$switchyard$deploy$osgi$internal$SwitchYardContainerImpl$State = new int[State.values().length];
            try {
                3.$SwitchMap$org$switchyard$deploy$osgi$internal$SwitchYardContainerImpl$State[State.Unknown.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$switchyard$deploy$osgi$internal$SwitchYardContainerImpl$State[State.WaitForCdi.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$switchyard$deploy$osgi$internal$SwitchYardContainerImpl$State[State.WaitForNamespaceHandlers.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$switchyard$deploy$osgi$internal$SwitchYardContainerImpl$State[State.WaitForComponents.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$switchyard$deploy$osgi$internal$SwitchYardContainerImpl$State[State.Created.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$switchyard$deploy$osgi$internal$SwitchYardContainerImpl$State[State.Failed.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static final class OsgiPropertyResolver
    implements PropertyResolver {
        private org.osgi.service.cm.Configuration _wrapped;

        private OsgiPropertyResolver(org.osgi.service.cm.Configuration wrapped) {
            this._wrapped = wrapped;
        }

        public Object resolveProperty(String key) {
            return this._wrapped.getProperties() != null ? this._wrapped.getProperties().get(key) : null;
        }

        private static void set(SwitchYardModel switchyardModel, Bundle bundle) throws Exception {
            ServiceReference configurationAdminReference = bundle.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)bundle.getBundleContext().getService(configurationAdminReference);
            org.osgi.service.cm.Configuration osgiConfig = configAdmin.getConfiguration(bundle.getSymbolicName());
            if (osgiConfig != null) {
                Configuration config = switchyardModel.getModelConfiguration();
                config.setPropertyResolver(CompoundPropertyResolver.compact((PropertyResolver[])new PropertyResolver[]{config.getPropertyResolver(), new OsgiPropertyResolver(osgiConfig)}));
            }
        }

        static /* synthetic */ void access$500(SwitchYardModel x0, Bundle x1) throws Exception {
            OsgiPropertyResolver.set(x0, x1);
        }
    }

    private class OsgiDescriptor
    extends Descriptor {
        private NamespaceHandlerSet _namespaceHandlers;

        OsgiDescriptor(NamespaceHandlerSet namespaceHandlers) {
            this._namespaceHandlers = namespaceHandlers;
        }

        public synchronized Schema getSchema(Set<String> namespaces) {
            try {
                return this._namespaceHandlers.getSchema();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized Marshaller getMarshaller(String namespace) {
            return this._namespaceHandlers.getNamespaceHandler(URI.create(namespace)).createMarshaller(namespace, this);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static enum State {
        Unknown,
        WaitForCdi,
        WaitForNamespaceHandlers,
        WaitForComponents,
        Created,
        Failed;

    }
}

