/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.type.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.reflect.Access;

public final class FieldAccess<T>
implements Access<T> {
    private Field _field;

    public FieldAccess(Field field) {
        this.setField(field);
    }

    public FieldAccess(Class<?> clazz, String fieldName) {
        fieldName = Strings.trimToNull(fieldName);
        if (fieldName != null) {
            Field field;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException nsfe1) {
                try {
                    field = clazz.getField(fieldName);
                }
                catch (NoSuchFieldException nsfe2) {
                    field = null;
                }
            }
            if (field != null) {
                this.setField(field);
            }
        }
    }

    private void setField(Field field) {
        this._field = field;
        if (field != null && !this._field.isAccessible()) {
            this._field.setAccessible(true);
        }
    }

    @Override
    public String getName() {
        if (this._field != null) {
            return this._field.getName();
        }
        return null;
    }

    @Override
    public Class<T> getType() {
        if (this._field != null) {
            return this._field.getType();
        }
        return null;
    }

    @Override
    public boolean isReadable() {
        if (this._field != null) {
            return !Modifier.isStatic(this._field.getModifiers());
        }
        return false;
    }

    @Override
    public boolean isWriteable() {
        if (this._field != null) {
            int mod = this._field.getModifiers();
            return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
        }
        return false;
    }

    @Override
    public T read(Object target) {
        try {
            return (T)this._field.get(target);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (NullPointerException npe) {
            throw new RuntimeException(npe);
        }
    }

    @Override
    public void write(Object target, T value) {
        try {
            this._field.set(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (NullPointerException npe) {
            throw new RuntimeException(npe);
        }
    }

    public String toString() {
        Class<T> clazz = this.getType();
        String type = clazz != null ? clazz.getSimpleName() : null;
        return String.format("FieldAccess(name=%s, type=%s, readable=%b, writeable=%b)", this.getName(), type, this.isReadable(), this.isWriteable());
    }
}

