/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.ops4j.pax.cdi.api.OsgiService;
import org.ops4j.pax.cdi.extension.impl.client.OsgiServiceInstance;
import org.ops4j.pax.cdi.extension.impl.util.InjectionPointOsgiUtils;
import org.osgi.framework.BundleContext;

public class OsgiInjectionTarget<T>
implements InjectionTarget<T> {
    private InjectionTarget<T> delegate;

    public OsgiInjectionTarget(InjectionTarget<T> delegate) {
        this.delegate = delegate;
    }

    public T produce(CreationalContext<T> creationalContext) {
        return (T)this.delegate.produce(creationalContext);
    }

    public void dispose(T instance) {
        this.delegate.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.delegate.getInjectionPoints();
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        this.delegate.inject(instance, ctx);
        for (InjectionPoint ip : this.delegate.getInjectionPoints()) {
            this.overrideInstanceInjection(instance, ip);
        }
    }

    private void overrideInstanceInjection(T beanInstance, InjectionPoint ip) {
        OsgiService qualifier = this.getOsgiServiceQualifier(ip);
        if (qualifier == null) {
            return;
        }
        Type instanceType = InjectionPointOsgiUtils.getInstanceType(ip);
        if (instanceType == null) {
            return;
        }
        BundleContext bc = InjectionPointOsgiUtils.getBundleContext(ip);
        OsgiServiceInstance instance = new OsgiServiceInstance(bc, (Class)instanceType, qualifier.filter());
        Annotated annotated = ip.getAnnotated();
        if (annotated instanceof AnnotatedField) {
            AnnotatedField annotatedField = (AnnotatedField)annotated;
            Field field = annotatedField.getJavaMember();
            field.setAccessible(true);
            try {
                field.set(beanInstance, instance);
            }
            catch (IllegalArgumentException exc) {
                throw new RuntimeException(exc);
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    private OsgiService getOsgiServiceQualifier(InjectionPoint ip) {
        for (Annotation qualifier : ip.getQualifiers()) {
            if (!(qualifier instanceof OsgiService)) continue;
            return (OsgiService)qualifier;
        }
        return null;
    }

    public void postConstruct(T instance) {
        this.delegate.postConstruct(instance);
    }

    public void preDestroy(T instance) {
        this.delegate.preDestroy(instance);
    }
}

