/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.ops4j.pax.cdi.api.OsgiService;
import org.ops4j.pax.cdi.extension.impl.client.AbstractServiceInvocationHandler;
import org.ops4j.pax.cdi.extension.impl.client.OsgiServiceQualifierType;
import org.ops4j.pax.cdi.extension.impl.client.ProxyFactory;
import org.osgi.framework.ServiceException;

public class OsgiServiceBean<T>
implements Bean<T> {
    private Type type;
    private InjectionPoint ip;
    private OsgiService qualifier;

    public OsgiServiceBean(InjectionPoint injectionPoint) {
        this.ip = injectionPoint;
        this.type = this.ip.getType();
        this.qualifier = (OsgiService)this.ip.getAnnotated().getAnnotation(OsgiService.class);
    }

    public T create(CreationalContext<T> ctx) {
        try {
            return (T)ProxyFactory.getServiceProxy(this.ip);
        }
        catch (ServiceException exc) {
            throw new CreationException((Throwable)exc);
        }
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        InvocationHandler handler = Proxy.getInvocationHandler(instance);
        if (handler instanceof AbstractServiceInvocationHandler) {
            AbstractServiceInvocationHandler serviceHandler = (AbstractServiceInvocationHandler)handler;
            serviceHandler.release();
        }
    }

    public Class<T> getBeanClass() {
        if (this.type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)this.type;
            return (Class)ptype.getRawType();
        }
        return (Class)this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> s = new HashSet<Annotation>();
        s.add((Annotation)((Object)new OsgiServiceQualifierType(this.qualifier)));
        return s;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        HashSet<Type> s = new HashSet<Type>();
        s.add(this.type);
        s.add((Type)((Object)Object.class));
        return s;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return true;
    }
}

