/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.client;

import java.lang.reflect.Proxy;
import javax.enterprise.inject.spi.InjectionPoint;
import org.ops4j.pax.cdi.api.OsgiService;
import org.ops4j.pax.cdi.extension.impl.client.AbstractServiceInvocationHandler;
import org.ops4j.pax.cdi.extension.impl.client.DynamicInvocationHandler;
import org.ops4j.pax.cdi.extension.impl.client.StaticInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFactory {
    private static Logger log = LoggerFactory.getLogger(ProxyFactory.class);

    private ProxyFactory() {
    }

    public static <T> Object getServiceProxy(InjectionPoint ip) {
        OsgiService qualifier = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
        log.debug("getting service proxy for {}, {} ", (Object)ip.getType(), (Object)qualifier);
        T instance = ProxyFactory.createServiceProxy(ip);
        return instance;
    }

    private static <T> T createServiceProxy(InjectionPoint ip) {
        Class klass = (Class)ip.getType();
        OsgiService os = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
        AbstractServiceInvocationHandler handler = os.dynamic() ? new DynamicInvocationHandler(ip) : new StaticInvocationHandler(ip);
        ClassLoader classLoader = ip.getMember().getDeclaringClass().getClassLoader();
        Object instance = Proxy.newProxyInstance(classLoader, new Class[]{klass}, handler);
        return (T)instance;
    }
}

