/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.compat;

import org.ops4j.pax.cdi.extension.impl.compat.ServiceObjectsWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeScopeUtils {
    private static Logger log = LoggerFactory.getLogger(PrototypeScopeUtils.class);
    private static Class<?> wrapperClass;

    private PrototypeScopeUtils() {
    }

    public static <S> ServiceObjectsWrapper<S> createServiceObjectsWrapper(BundleContext bc, ServiceReference<S> serviceReference) {
        ServiceObjectsWrapper<S> w = PrototypeScopeUtils.instantiateWrapper(bc);
        w.init(bc, serviceReference);
        return w;
    }

    private static <S> ServiceObjectsWrapper<S> instantiateWrapper(BundleContext bc) {
        try {
            Object instance = PrototypeScopeUtils.getWrapperClass(bc).newInstance();
            return (ServiceObjectsWrapper)instance;
        }
        catch (InstantiationException exc) {
            log.error("", (Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            log.error("", (Throwable)exc);
        }
        return null;
    }

    private static Class<?> getWrapperClass(BundleContext bc) {
        if (wrapperClass == null) {
            wrapperClass = PrototypeScopeUtils.loadWrapperClass(bc);
        }
        return wrapperClass;
    }

    private static Class<?> loadWrapperClass(BundleContext bc) {
        String simpleClassName = PrototypeScopeUtils.getWrapperClassName(bc);
        String className = String.format("%s.%s", PrototypeScopeUtils.class.getPackage().getName(), simpleClassName);
        try {
            Class<?> klass = Class.forName(className, true, PrototypeScopeUtils.class.getClassLoader());
            return klass;
        }
        catch (ClassNotFoundException exc) {
            throw new IllegalArgumentException(exc);
        }
    }

    private static String getWrapperClassName(BundleContext bc) {
        if (PrototypeScopeUtils.hasPrototypeScope(bc)) {
            return "Osgi6ServiceObjectsWrapper";
        }
        return "Osgi5ServiceObjectsWrapper";
    }

    public static boolean hasPrototypeScope(BundleContext bc) {
        Version actualVersion = Version.parseVersion((String)bc.getProperty("org.osgi.framework.version"));
        return actualVersion.compareTo(new Version(1, 8, 0)) >= 0;
    }
}

