/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.component;

import javax.enterprise.inject.spi.InjectionPoint;
import org.ops4j.pax.cdi.extension.impl.component.ComponentDescriptor;
import org.ops4j.pax.cdi.extension.impl.util.InjectionPointOsgiUtils;
import org.ops4j.pax.swissbox.lifecycle.AbstractLifecycle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ComponentDependency<S, T>
extends AbstractLifecycle
implements ServiceTrackerCustomizer<T, T> {
    private InjectionPoint injectionPoint;
    private Filter filter;
    private boolean satisfied;
    private ServiceTracker<T, T> tracker;
    private ComponentDescriptor<S> parent;
    private BundleContext bc;

    public ComponentDependency(ComponentDescriptor<S> parent, InjectionPoint ip, Filter filter) {
        this.parent = parent;
        this.injectionPoint = ip;
        this.filter = filter;
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public void setInjectionPoint(InjectionPoint injectionPoint) {
        this.injectionPoint = injectionPoint;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public void setSatisfied(boolean satisfied) {
        this.satisfied = satisfied;
    }

    protected void onStart() {
        this.bc = InjectionPointOsgiUtils.getBundleContext(this.injectionPoint);
        this.tracker = new ServiceTracker(this.bc, this.filter, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    protected void onStop() {
        this.tracker.close();
    }

    public T addingService(ServiceReference<T> reference) {
        if (!this.satisfied) {
            this.satisfied = true;
            this.parent.onDependencySatisfied();
            return (T)this.bc.getService(reference);
        }
        return null;
    }

    public void modifiedService(ServiceReference<T> reference, T service) {
    }

    public void removedService(ServiceReference<T> reference, T service) {
        if (this.satisfied) {
            this.satisfied = false;
            this.parent.onDependencyUnsatisfied();
        }
    }
}

